/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPCreateWorldPoint
extends Packet {
    private int ordinal;
    private String name;
    private String description;

    public SPCreateWorldPoint() {
    }

    public SPCreateWorldPoint(WorldPoint.EnumWorldPoint point, String name, String description) {
        this.ordinal = point.ordinal();
        this.name = name;
        this.description = description;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        ByteBufUtils.writeString((String)this.name, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.description, (ByteBuf)buffer);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPCreateWorldPoint.getEntityPlayerMP((INetHandler)netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)15) && (ordinal = buffer.readByte()) >= 0 && ordinal < WorldPoint.EnumWorldPoint.values().length) {
            WorldPoint.EnumWorldPoint point = WorldPoint.EnumWorldPoint.values()[ordinal];
            String name = ByteBufUtils.readString((ByteBuf)buffer);
            String description = ByteBufUtils.readString((ByteBuf)buffer);
            switch (point) {
                case CAMP: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getPlayersDataManager().createCamp(playerMP, name, description));
                    break;
                }
                case LOCATION: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getLocationsManager().createLocation(playerMP, name, description));
                }
            }
        }
    }
}

