/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPEditWorldPoint
extends Packet {
    private int ordinal;
    private long pointId;
    private String name;
    private String description;
    private boolean updatePosition;
    private boolean updateImage;

    public SPEditWorldPoint() {
    }

    public SPEditWorldPoint(WorldPoint.EnumWorldPoint point, long pointId, String name, String description, boolean updatePosition, boolean updateImage) {
        this.ordinal = point.ordinal();
        this.pointId = pointId;
        this.name = name;
        this.description = description;
        this.updatePosition = updatePosition;
        this.updateImage = updateImage;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.pointId);
        ByteBufUtils.writeString((String)this.name, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.description, (ByteBuf)buffer);
        buffer.writeBoolean(this.updatePosition);
        buffer.writeBoolean(this.updateImage);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPEditWorldPoint.getEntityPlayerMP((INetHandler)netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)15) && (ordinal = buffer.readByte()) >= 0 && ordinal < WorldPoint.EnumWorldPoint.values().length) {
            WorldPoint.EnumWorldPoint point = WorldPoint.EnumWorldPoint.values()[ordinal];
            long pointId = buffer.readLong();
            String name = ByteBufUtils.readString((ByteBuf)buffer);
            String description = ByteBufUtils.readString((ByteBuf)buffer);
            boolean updatePosition = buffer.readBoolean();
            boolean updateImage = buffer.readBoolean();
            switch (point) {
                case CAMP: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getPlayersDataManager().editCamp(playerMP, pointId, name, description, updatePosition, updateImage));
                    break;
                }
                case LOCATION: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getLocationsManager().editLocation(playerMP, pointId, name, description, updatePosition, updateImage));
                }
            }
        }
    }
}

