/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPManageInvitation
extends Packet {
    private int ordinal;
    private long pointId;
    private UUID playerUUID;

    public SPManageInvitation() {
    }

    public SPManageInvitation(EnumOperation operation, long pointId, UUID playerUUID) {
        this.ordinal = operation.ordinal();
        this.pointId = pointId;
        this.playerUUID = playerUUID;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.pointId);
        ByteBufUtils.writeUUID((UUID)this.playerUUID, (ByteBuf)buffer);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPManageInvitation.getEntityPlayerMP((INetHandler)netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)15) && (ordinal = buffer.readByte()) >= 0 && ordinal < EnumOperation.values().length) {
            EnumOperation operation = EnumOperation.values()[ordinal];
            long pointId = buffer.readLong();
            UUID playerUUID = ByteBufUtils.readUUID((ByteBuf)buffer);
            switch (operation) {
                case INVITE: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getPlayersDataManager().invitePlayer(playerMP, pointId, playerUUID));
                    break;
                }
                case UNINVITE: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getPlayersDataManager().uninvitePlayer(playerMP, pointId, playerUUID));
                }
            }
        }
    }

    public static enum EnumOperation {
        INVITE,
        UNINVITE;

    }
}

