/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPMoveToPoint
extends Packet {
    private int ordinal;
    private long pointId;

    public SPMoveToPoint() {
    }

    public SPMoveToPoint(WorldPoint.EnumWorldPoint point, long pointId) {
        this.ordinal = point.ordinal();
        this.pointId = pointId;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.pointId);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPMoveToPoint.getEntityPlayerMP((INetHandler)netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)17) && (ordinal = buffer.readByte()) >= 0 && ordinal < WorldPoint.EnumWorldPoint.values().length) {
            WorldPoint.EnumWorldPoint point = WorldPoint.EnumWorldPoint.values()[ordinal];
            long pointId = buffer.readLong();
            switch (point) {
                case CAMP: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getPlayersDataManager().moveToCamp(playerMP, pointId));
                    break;
                }
                case LOCATION: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getLocationsManager().moveToLocation(playerMP, pointId));
                }
            }
        }
    }
}

