/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPRemoveWorldPoint
extends Packet {
    private int ordinal;
    private long pointId;

    public SPRemoveWorldPoint() {
    }

    public SPRemoveWorldPoint(WorldPoint.EnumWorldPoint point, long pointId) {
        this.ordinal = point.ordinal();
        this.pointId = pointId;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.pointId);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPRemoveWorldPoint.getEntityPlayerMP((INetHandler)netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)15) && (ordinal = buffer.readByte()) >= 0 && ordinal < WorldPoint.EnumWorldPoint.values().length) {
            WorldPoint.EnumWorldPoint point = WorldPoint.EnumWorldPoint.values()[ordinal];
            long pointId = buffer.readLong();
            switch (point) {
                case CAMP: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getPlayersDataManager().removeCamp(playerMP, pointId));
                    break;
                }
                case LOCATION: {
                    OxygenHelperServer.addRoutineTask(() -> TeleportationManagerServer.instance().getLocationsManager().removeLocation(playerMP, pointId));
                }
            }
        }
    }
}

