/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.util.ImageTransferingServerBuffer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPUploadImagePart
extends Packet {
    private int ordinal;
    private int index;
    private int fragmentsAmount;
    private long pointId;
    private byte[] fragment;

    public SPUploadImagePart() {
    }

    public SPUploadImagePart(ImageTransferingServerBuffer.EnumImageTransfer operation, long pointId, int index, byte[] fragment, int fragmentsAmount) {
        this.ordinal = operation.ordinal();
        this.pointId = pointId;
        this.index = index;
        this.fragment = fragment;
        this.fragmentsAmount = fragmentsAmount;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.pointId);
        buffer.writeShort(this.index);
        buffer.writeShort(this.fragmentsAmount);
        buffer.writeShort(this.fragment.length);
        buffer.writeBytes(this.fragment);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        EntityPlayerMP playerMP = SPUploadImagePart.getEntityPlayerMP((INetHandler)netHandler);
        byte ordinal = buffer.readByte();
        if (ordinal >= 0 && ordinal < ImageTransferingServerBuffer.EnumImageTransfer.values().length) {
            ImageTransferingServerBuffer.EnumImageTransfer operation = ImageTransferingServerBuffer.EnumImageTransfer.values()[ordinal];
            long pointId = buffer.readLong();
            short index = buffer.readShort();
            short fragmentsAmount = buffer.readShort();
            byte[] fragment = new byte[buffer.readShort()];
            buffer.readBytes(fragment);
            OxygenHelperServer.addRoutineTask(() -> ImageTransferingServerBuffer.processFragment(operation, CommonReference.getPersistentUUID((Entity)playerMP), pointId, fragmentsAmount, index, fragment));
        }
    }
}

