/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.common.util;

import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.util.BufferedImageUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class ImageTransferingServerBuffer {
    private final EnumImageTransfer operation;
    private UUID playerUUID;
    private final long pointId;
    private int fragmentsAmount;
    private final Map<Integer, byte[]> fragments = new HashMap<Integer, byte[]>();

    private ImageTransferingServerBuffer(EnumImageTransfer operation, UUID playerUUID, long pointId, int fragmentsAmount) {
        this.playerUUID = playerUUID;
        this.pointId = pointId;
        this.operation = operation;
        this.fragmentsAmount = fragmentsAmount;
    }

    public static boolean create(EnumImageTransfer operation, UUID playerUUID, long pointId, int fragmentsAmount) {
        if (!ImageTransferingServerBuffer.exist(pointId) && (operation == EnumImageTransfer.UPLOAD_CAMP && TeleportationManagerServer.instance().getPlayersDataContainer().getPlayerData(playerUUID).isCampExist(pointId) || operation == EnumImageTransfer.UPLOAD_LOCATION && TeleportationManagerServer.instance().getLocationsContainer().locationExist(pointId))) {
            TeleportationManagerServer.instance().getImagesManager().getImageTransfers().put(pointId, new ImageTransferingServerBuffer(operation, playerUUID, pointId, fragmentsAmount));
            return true;
        }
        return false;
    }

    public static void processFragment(EnumImageTransfer operation, UUID playerUUID, long pointId, int fragmentsAmount, int index, byte[] fragment) {
        if (ImageTransferingServerBuffer.exist(pointId)) {
            ImageTransferingServerBuffer.get(pointId).addPart(index, fragment);
        } else if (OxygenHelperServer.isNetworkRequestAvailable((UUID)playerUUID, (int)16) && ImageTransferingServerBuffer.create(operation, playerUUID, pointId, fragmentsAmount)) {
            ImageTransferingServerBuffer.get(pointId).addPart(index, fragment);
        }
    }

    public static boolean exist(long pointId) {
        return TeleportationManagerServer.instance().getImagesManager().getImageTransfers().containsKey(pointId);
    }

    public static ImageTransferingServerBuffer get(long pointId) {
        return TeleportationManagerServer.instance().getImagesManager().getImageTransfers().get(pointId);
    }

    public void addPart(int index, byte[] fragment) {
        if (this.fragments.size() > 100 || this.fragments.containsKey(index)) {
            TeleportationManagerServer.instance().getImagesManager().getImageTransfers().remove(this.pointId);
        } else {
            this.fragments.put(index, fragment);
            if (this.fragments.size() == this.fragmentsAmount) {
                this.process();
            }
        }
    }

    private void process() {
        ArrayList<byte[]> ordered = new ArrayList<byte[]>();
        for (int i = 0; i < this.fragmentsAmount; ++i) {
            ordered.add(this.fragments.get(i));
        }
        if (this.operation == EnumImageTransfer.UPLOAD_CAMP) {
            byte[] merged = this.mergeArrays(ordered);
            if (merged != null) {
                TeleportationManagerServer.instance().getImagesLoader().saveCampPreviewImageAsync(this.playerUUID, this.pointId, merged);
            }
            OxygenMain.LOGGER.info("[Teleportation] Camp preview image {}.png uploaded by player: {}", (Object)this.pointId, (Object)this.playerUUID);
        } else {
            byte[] merged = this.mergeArrays(ordered);
            if (merged != null) {
                TeleportationManagerServer.instance().getImagesLoader().saveAndLoadBytesLocationPreviewAsync(this.pointId, merged);
            }
            OxygenMain.LOGGER.info("[Teleportation] Location preview image {}.png uploaded by player: {}", (Object)this.pointId, (Object)this.playerUUID);
        }
        TeleportationManagerServer.instance().getImagesManager().getImageTransfers().remove(this.pointId);
    }

    @Nullable
    private byte[] mergeArrays(List<byte[]> ordered) {
        byte[] merged = null;
        try {
            merged = BufferedImageUtils.mergeByteArrays(ordered);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Teleportation] Failed to merge raw image fragments {}.png uploaded by player: {}", (Object)this.pointId, (Object)this.playerUUID);
            exception.printStackTrace();
        }
        return merged;
    }

    public static enum EnumImageTransfer {
        UPLOAD_CAMP,
        UPLOAD_LOCATION;

    }
}

