/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.process.AbstractTemporaryProcess;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.server.api.CurrencyHelperServer;
import austeretony.oxygen_core.server.api.InventoryProviderServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_core.server.api.SoundEventHelperServer;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationStatusMessage;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class AbstractTeleportation
extends AbstractTemporaryProcess {
    protected final EntityPlayerMP playerMP;
    protected final double prevX;
    protected final double prevZ;
    protected final long fee;
    protected final boolean processOnMove;
    protected int delaySeconds;
    public static final long TELEPORTATION_PROCESS_ID = 1000L;

    public AbstractTeleportation(EntityPlayerMP playerMP, int delaySeconds, long fee) {
        this.playerMP = playerMP;
        this.prevX = playerMP.field_70165_t;
        this.prevZ = playerMP.field_70161_v;
        int n = this.delaySeconds = delaySeconds < 1 ? 1 : delaySeconds;
        if (this.delaySeconds > 1) {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.PREPARE_FOR_TELEPORTATION.ordinal(), (String[])new String[0]);
        }
        this.fee = fee;
        this.processOnMove = PrivilegesProviderServer.getAsBoolean((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)EnumTeleportationPrivilege.PROCESS_TELEPORTATION_ON_MOVE.id(), (boolean)TeleportationConfig.PROCESS_TELEPORTATION_ON_MOVE.asBoolean());
    }

    public long getId() {
        return 1000L;
    }

    public int getExpireTimeSeconds() {
        return this.delaySeconds;
    }

    public void process() {
    }

    public boolean isExpired() {
        if (this.update()) {
            if (System.currentTimeMillis() >= this.getExpirationTimeStamp()) {
                this.expired();
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean update() {
        if (!(this.processOnMove || this.playerMP.field_70165_t == this.prevX && this.playerMP.field_70161_v == this.prevZ)) {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)this.playerMP, (int)1, (int)EnumTeleportationStatusMessage.TELEPORTATION_ABORTED.ordinal(), (String[])new String[0]);
            return false;
        }
        return true;
    }

    public void expired() {
        if (this.fee > 0L) {
            if (TeleportationConfig.FEE_MODE.asInt() == 1) {
                if ((long)InventoryProviderServer.getPlayerInventory().getEqualItemAmount((EntityPlayer)this.playerMP, TeleportationManagerServer.instance().getFeeStackWrapper()) < this.fee) {
                    return;
                }
                InventoryProviderServer.getPlayerInventory().removeItem((EntityPlayer)this.playerMP, TeleportationManagerServer.instance().getFeeStackWrapper(), (int)this.fee);
                SoundEventHelperServer.playSoundClient((EntityPlayerMP)this.playerMP, (int)OxygenSoundEffects.INVENTORY_OPERATION.getId());
            } else {
                UUID playerUUID = CommonReference.getPersistentUUID((Entity)this.playerMP);
                if (!CurrencyHelperServer.enoughCurrency((UUID)playerUUID, (long)this.fee, (int)0)) {
                    return;
                }
                CurrencyHelperServer.removeCurrency((UUID)playerUUID, (long)this.fee, (int)0);
                SoundEventHelperServer.playSoundClient((EntityPlayerMP)this.playerMP, (int)OxygenSoundEffects.RINGING_COINS.getId());
            }
        }
        this.move();
    }

    public abstract void move();
}

