/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.notification.AbstractNotification;
import austeretony.oxygen_core.common.notification.EnumNotification;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationStatusMessage;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class CampInvitationRequest
extends AbstractNotification {
    public final int index;
    public final String ownerUsername;
    public final String campName;
    public final UUID ownerUUID;
    public final long pointId;

    public CampInvitationRequest(int index, UUID ownerUUID, String ownerUsername, long pointId, String campName) {
        this.index = index;
        this.ownerUUID = ownerUUID;
        this.ownerUsername = ownerUsername;
        this.pointId = pointId;
        this.campName = campName;
    }

    public EnumNotification getType() {
        return EnumNotification.REQUEST;
    }

    public String getDescription() {
        return "oxygen_teleportation.invitation.request";
    }

    public String[] getArguments() {
        return new String[]{this.ownerUsername, this.campName};
    }

    public int getIndex() {
        return this.index;
    }

    public int getExpireTimeSeconds() {
        return TeleportationConfig.INVITATION_REQUEST_EXPIRE_TIME_SECONDS.asInt();
    }

    public void process() {
    }

    public void accepted(EntityPlayer player) {
        UUID targetUUID = CommonReference.getPersistentUUID((Entity)player);
        TeleportationManagerServer.instance().getSharedCampsContainer().invite(this.ownerUUID, this.pointId, targetUUID);
        TeleportationManagerServer.instance().getSharedCampsContainer().setChanged(true);
        OxygenHelperServer.addObservedPlayer((UUID)this.ownerUUID, (UUID)targetUUID);
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)((EntityPlayerMP)player), (int)1, (int)EnumTeleportationStatusMessage.INVITATION_REQUEST_ACCEPTED.ordinal(), (String[])new String[0]);
        if (OxygenHelperServer.isPlayerOnline((UUID)this.ownerUUID)) {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)CommonReference.playerByUUID((UUID)this.ownerUUID), (int)1, (int)EnumTeleportationStatusMessage.INVITATION_REQUEST_ACCEPTED_OWNER.ordinal(), (String[])new String[0]);
        }
    }

    public void rejected(EntityPlayer player) {
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)((EntityPlayerMP)player), (int)1, (int)EnumTeleportationStatusMessage.INVITATION_REQUEST_REJECTED.ordinal(), (String[])new String[0]);
        if (OxygenHelperServer.isPlayerOnline((UUID)this.ownerUUID)) {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)CommonReference.playerByUUID((UUID)this.ownerUUID), (int)1, (int)EnumTeleportationStatusMessage.INVITATION_REQUEST_REJECTED_OWNER.ordinal(), (String[])new String[0]);
        }
    }

    public void expired() {
    }
}

