/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_teleportation.common.TeleportationPlayerData;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationStatusMessage;
import austeretony.oxygen_teleportation.common.network.client.CPSyncCooldown;
import austeretony.oxygen_teleportation.server.AbstractTeleportation;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class CampTeleportation
extends AbstractTeleportation {
    private final int dimension;
    private final float xPos;
    private final float yPos;
    private final float zPos;
    private final float yaw;
    private final float pitch;

    public CampTeleportation(EntityPlayerMP playerMP, WorldPoint camp) {
        super(playerMP, PrivilegesProviderServer.getAsInt((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)EnumTeleportationPrivilege.CAMP_TELEPORTATION_DELAY_SECONDS.id(), (int)TeleportationConfig.CAMP_TELEPORTATION_DELAY_SECONDS.asInt()), PrivilegesProviderServer.getAsLong((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)EnumTeleportationPrivilege.CAMP_TELEPORTATION_FEE.id(), (long)TeleportationConfig.CAMP_TELEPORTATION_FEE.asLong()));
        this.dimension = camp.getDimensionId();
        this.xPos = camp.getXPos();
        this.yPos = camp.getYPos();
        this.zPos = camp.getZPos();
        this.yaw = camp.getYaw();
        this.pitch = camp.getPitch();
    }

    @Override
    public void move() {
        CommonReference.delegateToServerThread(() -> CommonReference.teleportPlayer((EntityPlayerMP)this.playerMP, (int)this.dimension, (double)this.xPos, (double)this.yPos, (double)this.zPos, (float)this.yaw, (float)this.pitch));
        this.setCooldown();
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)this.playerMP, (int)1, (int)EnumTeleportationStatusMessage.MOVED_TO_CAMP.ordinal(), (String[])new String[0]);
    }

    private void setCooldown() {
        if (PrivilegesProviderServer.getAsInt((UUID)CommonReference.getPersistentUUID((Entity)this.playerMP), (int)EnumTeleportationPrivilege.CAMP_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.CAMP_TELEPORTATION_COOLDOWN_SECONDS.asInt()) > 0) {
            TeleportationPlayerData playerData = TeleportationManagerServer.instance().getPlayersDataContainer().getPlayerData(CommonReference.getPersistentUUID((Entity)this.playerMP));
            playerData.getCooldownData().movedToCamp();
            playerData.setChanged(true);
            UUID playerUUID = CommonReference.getPersistentUUID((Entity)this.playerMP);
            int campCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.CAMP_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.CAMP_TELEPORTATION_COOLDOWN_SECONDS.asInt());
            int campCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextCampTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)campCooldownSeconds);
            int locationCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.LOCATION_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.LOCATION_TELEPORTATION_COOLDOWN_SECONDS.asInt());
            int locationCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextLocationTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)locationCooldownSeconds);
            int jumpCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.asInt());
            int jumpCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextJumpTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)jumpCooldownSeconds);
            OxygenMain.network().sendTo((Packet)new CPSyncCooldown(campCooldownLeftSeconds, locationCooldownLeftSeconds, jumpCooldownLeftSeconds), this.playerMP);
        }
    }
}

