/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_core.server.sync.DataSyncHandlerServer;
import austeretony.oxygen_teleportation.common.TeleportationPlayerData;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import austeretony.oxygen_teleportation.common.network.client.CPSyncAdditionalData;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;

public class CampsSyncHandlerServer
implements DataSyncHandlerServer<WorldPoint> {
    public int getDataId() {
        return 10;
    }

    public boolean allowSync(UUID playerUUID) {
        this.syncAdditionalData(playerUUID);
        return true;
    }

    private void syncAdditionalData(UUID playerUUID) {
        EntityPlayerMP playerMP = CommonReference.playerByUUID((UUID)playerUUID);
        TeleportationPlayerData playerData = TeleportationManagerServer.instance().getPlayersDataContainer().getPlayerData(playerUUID);
        long invitationsId = TeleportationManagerServer.instance().getSharedCampsContainer().haveInvitedPlayers(playerUUID) ? TeleportationManagerServer.instance().getSharedCampsContainer().getInvitationsContainer(playerUUID).getId() : 0L;
        int campCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.CAMP_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.CAMP_TELEPORTATION_COOLDOWN_SECONDS.asInt());
        int campCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextCampTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)campCooldownSeconds);
        int locationCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.LOCATION_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.LOCATION_TELEPORTATION_COOLDOWN_SECONDS.asInt());
        int locationCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextLocationTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)locationCooldownSeconds);
        int jumpCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.asInt());
        int jumpCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextJumpTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)jumpCooldownSeconds);
        OxygenMain.network().sendTo((Packet)new CPSyncAdditionalData(campCooldownLeftSeconds, locationCooldownLeftSeconds, jumpCooldownLeftSeconds, playerData.getFavoriteCampId(), invitationsId), playerMP);
    }

    public Set<Long> getIds(UUID playerUUID) {
        TeleportationPlayerData playerData = TeleportationManagerServer.instance().getPlayersDataContainer().getPlayerData(playerUUID);
        HashSet<Long> camps = new HashSet<Long>(playerData.getCampsAmount() + TeleportationManagerServer.instance().getSharedCampsContainer().getInvitationsAmount(playerUUID));
        for (long id : playerData.getCampIds()) {
            camps.add(id);
        }
        if (TeleportationManagerServer.instance().getSharedCampsContainer().haveInvitations(playerUUID)) {
            for (long id : TeleportationManagerServer.instance().getSharedCampsContainer().getInvitations(playerUUID)) {
                camps.add(id);
            }
        }
        return camps;
    }

    public WorldPoint getEntry(UUID playerUUID, long entryId) {
        TeleportationManagerServer.instance().getImagesLoader().loadAndSendCampPreviewImageAsync(CommonReference.playerByUUID((UUID)playerUUID), entryId);
        if (TeleportationManagerServer.instance().getSharedCampsContainer().haveInvitation(playerUUID, entryId)) {
            return TeleportationManagerServer.instance().getSharedCampsContainer().getCamp(entryId);
        }
        return TeleportationManagerServer.instance().getPlayersDataContainer().getPlayerData(playerUUID).getCamp(entryId);
    }
}

