/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.common.network.client.CPDownloadPreviewImage;
import austeretony.oxygen_teleportation.common.util.ImageTransferingServerBuffer;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayerMP;

public class ImagesManagerServer {
    private final TeleportationManagerServer manager;
    private final Map<Long, ImageTransferingServerBuffer> transfers = new ConcurrentHashMap<Long, ImageTransferingServerBuffer>(5);
    private final Map<Long, byte[]> rawImages = new ConcurrentHashMap<Long, byte[]>();

    protected ImagesManagerServer(TeleportationManagerServer manager) {
        this.manager = manager;
    }

    public Map<Long, ImageTransferingServerBuffer> getImageTransfers() {
        return this.transfers;
    }

    public Map<Long, byte[]> getLocationPreviews() {
        return this.rawImages;
    }

    public void replaceImageBytes(long oldPointId, long newPointId) {
        if (this.rawImages.containsKey(oldPointId)) {
            this.rawImages.put(newPointId, this.rawImages.get(oldPointId));
            this.rawImages.remove(oldPointId);
        }
    }

    public void downloadCampPreviewToClientAsync(EntityPlayerMP playerMP, long pointId, byte[] imageRaw) {
        OxygenHelperServer.addRoutineTask(() -> this.downloadCampPreviewToClient(playerMP, pointId, imageRaw));
    }

    public void downloadCampPreviewToClient(EntityPlayerMP playerMP, long pointId, byte[] imageRaw) {
        OxygenMain.network().sendTo((Packet)new CPDownloadPreviewImage(WorldPoint.EnumWorldPoint.CAMP, pointId, imageRaw), playerMP);
    }

    public void downloadLocationPreviewsToClientAsync(EntityPlayerMP playerMP, long[] locationIds) {
        OxygenHelperServer.addRoutineTask(() -> {
            for (long id : locationIds) {
                this.downloadLocationPreviewToClient(playerMP, id);
            }
        });
    }

    public void downloadLocationPreviewToClientAsync(EntityPlayerMP playerMP, long pointId) {
        OxygenHelperServer.addRoutineTask(() -> this.downloadLocationPreviewToClient(playerMP, pointId));
    }

    public void downloadLocationPreviewToClient(EntityPlayerMP playerMP, long pointId) {
        byte[] imageRaw = this.getLocationPreviews().get(pointId);
        if (imageRaw != null) {
            OxygenMain.network().sendTo((Packet)new CPDownloadPreviewImage(WorldPoint.EnumWorldPoint.LOCATION, pointId, imageRaw), playerMP);
        } else {
            OxygenMain.LOGGER.error("[Teleportation] Location preview image {}.png bytes are absent, can't download image.", (Object)pointId);
        }
    }
}

