/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_core.server.api.TimeHelperServer;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationStatusMessage;
import austeretony.oxygen_teleportation.common.network.client.CPWorldPointCreated;
import austeretony.oxygen_teleportation.common.network.client.CPWorldPointEdited;
import austeretony.oxygen_teleportation.common.network.client.CPWorldPointRemoved;
import austeretony.oxygen_teleportation.server.LocationTeleportation;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class LocationsManagerServer {
    private final TeleportationManagerServer manager;

    protected LocationsManagerServer(TeleportationManagerServer manager) {
        this.manager = manager;
    }

    public void moveToLocation(EntityPlayerMP playerMP, long pointId) {
        WorldPoint location;
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_LOCATIONS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_LOCATIONS.asBoolean()) && (location = this.getLocation(pointId)) != null && this.locationAvailable(location, playerUUID) && !this.manager.getPlayersDataManager().isPlayerTeleporting(playerUUID) && this.readyMoveToLocation(playerUUID)) {
            if (!PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ENABLE_CROSS_DIM_TELEPORTATION.id(), (boolean)TeleportationConfig.ENABLE_CROSS_DIM_TELEPORTATION.asBoolean()) && playerMP.field_71093_bK != location.getDimensionId()) {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.CROSS_DIM_TELEPORTSTION_DISABLED.ordinal(), (String[])new String[0]);
                return;
            }
            this.manager.getPlayersDataManager().addTeleportation(new LocationTeleportation(playerMP, location));
        }
    }

    public void createLocation(EntityPlayerMP playerMP, String name, String description) {
        UUID playerUUID;
        if (TeleportationConfig.ENABLE_LOCATIONS.asBoolean() && PrivilegesProviderServer.getAsBoolean((UUID)(playerUUID = CommonReference.getPersistentUUID((Entity)playerMP)), (int)EnumTeleportationPrivilege.ALLOW_LOCATIONS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_LOCATIONS.asBoolean()) && this.canCreateLocation(playerUUID) && this.manager.getLocationsContainer().getLocationsAmount() < TeleportationConfig.LOCATIONS_MAX_AMOUNT.asInt()) {
            if ((name = name.trim()).length() > 20) {
                name = name.substring(0, 20);
            }
            if (name.isEmpty()) {
                name = String.format("Location #%d", this.manager.getLocationsContainer().getLocationsAmount() + 1);
            }
            if ((description = description.trim()).length() > 400) {
                description = description.substring(0, 20);
            }
            WorldPoint location = new WorldPoint(this.manager.getLocationsContainer().createId(TimeHelperServer.getCurrentMillis()), CommonReference.getPersistentUUID((Entity)playerMP), CommonReference.getName((Entity)playerMP), name, description, playerMP.field_71093_bK, (float)playerMP.field_70165_t, (float)playerMP.field_70163_u, (float)playerMP.field_70161_v, playerMP.field_70759_as, playerMP.field_70125_A);
            this.manager.getLocationsContainer().addLocation(location);
            this.manager.getLocationsContainer().setChanged(true);
            OxygenMain.network().sendTo((Packet)new CPWorldPointCreated(WorldPoint.EnumWorldPoint.LOCATION, location), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.LOCATION_CREATED.ordinal(), (String[])new String[0]);
        }
    }

    public void removeLocation(EntityPlayerMP playerMP, long pointId) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        WorldPoint location = this.getLocation(pointId);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_LOCATIONS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_LOCATIONS.asBoolean()) && location != null && this.canEditLocation(playerUUID, location)) {
            this.manager.getLocationsContainer().removeLocation(pointId);
            this.manager.getLocationsContainer().setChanged(true);
            this.manager.getImagesLoader().removeLocationPreviewImageAsync(pointId);
            OxygenMain.network().sendTo((Packet)new CPWorldPointRemoved(WorldPoint.EnumWorldPoint.LOCATION, location.getId()), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.LOCATION_REMOVED.ordinal(), (String[])new String[0]);
        }
    }

    public void changeLocationLockState(EntityPlayerMP playerMP, long pointId, boolean flag) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        WorldPoint location = this.getLocation(pointId);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_LOCATIONS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_LOCATIONS.asBoolean()) && location != null && this.canEditLocation(playerUUID, location)) {
            location.setLocked(flag);
            location.setId(this.manager.getLocationsContainer().createId(pointId));
            this.manager.getLocationsContainer().addLocation(location);
            this.manager.getLocationsContainer().removeLocation(pointId);
            this.manager.getLocationsContainer().setChanged(true);
            this.manager.getImagesLoader().renameLocationPreviewImageAsync(pointId, location.getId());
            this.manager.getImagesManager().replaceImageBytes(pointId, location.getId());
            OxygenMain.network().sendTo((Packet)new CPWorldPointEdited(WorldPoint.EnumWorldPoint.LOCATION, pointId, location, false), playerMP);
            if (flag) {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.LOCATION_LOCKED.ordinal(), (String[])new String[0]);
            } else {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.LOCATION_UNLOCKED.ordinal(), (String[])new String[0]);
            }
        }
    }

    public void editLocation(EntityPlayerMP playerMP, long pointId, String name, String description, boolean updatePosition, boolean updateImage) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        WorldPoint location = this.getLocation(pointId);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_LOCATIONS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_LOCATIONS.asBoolean()) && location != null && this.canEditLocation(playerUUID, location)) {
            long newPointId = this.manager.getLocationsContainer().createId(pointId);
            if ((name = name.trim()).length() > 20) {
                name = name.substring(0, 20);
            }
            if (name.isEmpty()) {
                name = "Location";
            }
            if ((description = description.trim()).length() > 400) {
                description = description.substring(0, 20);
            }
            location.setName(name);
            location.setDescription(description);
            if (updatePosition) {
                location.setPosition((float)playerMP.field_70165_t, (float)playerMP.field_70163_u, (float)playerMP.field_70161_v, playerMP.field_71093_bK, playerMP.field_70759_as, playerMP.field_70125_A);
            }
            if (updateImage) {
                this.manager.getImagesLoader().removeLocationPreviewImageAsync(pointId);
            }
            location.setId(newPointId);
            this.manager.getLocationsContainer().addLocation(location);
            this.manager.getLocationsContainer().removeLocation(pointId);
            this.manager.getLocationsContainer().setChanged(true);
            if (!updateImage) {
                this.manager.getImagesLoader().renameLocationPreviewImageAsync(pointId, newPointId);
                this.manager.getImagesManager().replaceImageBytes(pointId, newPointId);
            }
            OxygenMain.network().sendTo((Packet)new CPWorldPointEdited(WorldPoint.EnumWorldPoint.LOCATION, pointId, location, updateImage), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.LOCATION_EDITED.ordinal(), (String[])new String[0]);
        }
    }

    private boolean canCreateLocation(UUID playerUUID) {
        return TeleportationConfig.ALLOW_LOCATIONS_CREATION_FOR_ALL.asBoolean() || PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.LOCATIONS_CREATION.id(), (boolean)false) || PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.LOCATIONS_MANAGEMENT.id(), (boolean)false);
    }

    @Nullable
    private WorldPoint getLocation(long pointId) {
        return this.manager.getLocationsContainer().getLocation(pointId);
    }

    private boolean locationAvailable(WorldPoint worldPoint, UUID playerUUID) {
        return !worldPoint.isLocked() || PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ENABLE_TELEPORTATION_TO_LOCKED_LOCATIONS.id(), (boolean)false) || worldPoint.isOwner(playerUUID);
    }

    private boolean canEditLocation(UUID playerUUID, WorldPoint worldPoint) {
        return PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.LOCATIONS_MANAGEMENT.id(), (boolean)false) || worldPoint.isOwner(playerUUID);
    }

    private boolean readyMoveToLocation(UUID playerUUID) {
        return TimeHelperServer.getCurrentMillis() >= this.manager.getPlayersDataContainer().getPlayerData(playerUUID).getCooldownData().getNextLocationTime();
    }
}

