/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_teleportation.common.TeleportationPlayerData;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationStatusMessage;
import austeretony.oxygen_teleportation.common.network.client.CPSyncCooldown;
import austeretony.oxygen_teleportation.server.AbstractTeleportation;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayerTeleportation
extends AbstractTeleportation {
    private final EntityPlayerMP target;

    public PlayerTeleportation(EntityPlayerMP playerMP, EntityPlayerMP target) {
        super(playerMP, PrivilegesProviderServer.getAsInt((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_DELAY_SECONDS.id(), (int)TeleportationConfig.PLAYER_TELEPORTATION_DELAY_SECONDS.asInt()), PrivilegesProviderServer.getAsLong((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_FEE.id(), (long)TeleportationConfig.TELEPORTATION_TO_PLAYER_FEE.asLong()));
        this.target = target;
    }

    @Override
    public boolean update() {
        if (!(this.processOnMove || this.playerMP.field_70165_t == this.prevX && this.playerMP.field_70161_v == this.prevZ)) {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)this.playerMP, (int)1, (int)EnumTeleportationStatusMessage.TELEPORTATION_ABORTED.ordinal(), (String[])new String[0]);
            return false;
        }
        return OxygenHelperServer.isPlayerOnline((UUID)CommonReference.getPersistentUUID((Entity)this.target));
    }

    @Override
    public void move() {
        CommonReference.delegateToServerThread(() -> CommonReference.teleportPlayer((EntityPlayerMP)this.playerMP, (int)this.target.field_71093_bK, (double)this.target.field_70165_t, (double)this.target.field_70163_u, (double)this.target.field_70161_v, (float)this.target.field_70759_as, (float)this.target.field_70125_A));
        this.setCooldown();
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)this.playerMP, (int)1, (int)EnumTeleportationStatusMessage.MOVED_TO_PLAYER.ordinal(), (String[])new String[0]);
    }

    private void setCooldown() {
        if (PrivilegesProviderServer.getAsInt((UUID)CommonReference.getPersistentUUID((Entity)this.playerMP), (int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.asInt()) > 0) {
            TeleportationPlayerData playerData = TeleportationManagerServer.instance().getPlayersDataContainer().getPlayerData(CommonReference.getPersistentUUID((Entity)this.playerMP));
            playerData.getCooldownData().jumped();
            playerData.setChanged(true);
            UUID playerUUID = CommonReference.getPersistentUUID((Entity)this.playerMP);
            int campCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.CAMP_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.CAMP_TELEPORTATION_COOLDOWN_SECONDS.asInt());
            int campCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextCampTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)campCooldownSeconds);
            int locationCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.LOCATION_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.LOCATION_TELEPORTATION_COOLDOWN_SECONDS.asInt());
            int locationCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextLocationTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)locationCooldownSeconds);
            int jumpCooldownSeconds = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.id(), (int)TeleportationConfig.PLAYER_TELEPORTATION_COOLDOWN_SECONDS.asInt());
            int jumpCooldownLeftSeconds = (int)MathUtils.clamp((long)((playerData.getCooldownData().getNextJumpTime() - System.currentTimeMillis()) / 1000L), (long)0L, (long)jumpCooldownSeconds);
            OxygenMain.network().sendTo((Packet)new CPSyncCooldown(campCooldownLeftSeconds, locationCooldownLeftSeconds, jumpCooldownLeftSeconds), this.playerMP);
        }
    }
}

