/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.persistent.PersistentData;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.TeleportationPlayerData;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class PlayersDataContainerServer {
    private final Map<UUID, TeleportationPlayerData> players = new ConcurrentHashMap<UUID, TeleportationPlayerData>();

    protected PlayersDataContainerServer() {
    }

    public Collection<TeleportationPlayerData> getPlayersData() {
        return this.players.values();
    }

    public TeleportationPlayerData createPlayerData(UUID playerUUID) {
        TeleportationPlayerData playerData = new TeleportationPlayerData();
        playerData.setPlayerUUID(playerUUID);
        playerData.setPath(OxygenHelperServer.getDataFolder() + "/server/players/" + playerUUID + "/teleportation/player_data.dat");
        this.players.put(playerUUID, playerData);
        return playerData;
    }

    @Nullable
    public TeleportationPlayerData getPlayerData(UUID playerUUID) {
        return this.players.get(playerUUID);
    }

    void save() {
        for (TeleportationPlayerData playerData : this.players.values()) {
            if (!playerData.isChanged()) continue;
            playerData.setChanged(false);
            OxygenHelperServer.savePersistentDataAsync((PersistentData)playerData);
        }
    }
}

