/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.EnumOxygenStatusMessage;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.notification.Notification;
import austeretony.oxygen_core.common.persistent.PersistentData;
import austeretony.oxygen_core.common.process.TemporaryProcess;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_core.server.api.TimeHelperServer;
import austeretony.oxygen_teleportation.common.TeleportationPlayerData;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationPrivilege;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationStatusMessage;
import austeretony.oxygen_teleportation.common.network.client.CPFavoriteCampUpdated;
import austeretony.oxygen_teleportation.common.network.client.CPPlayerUninvited;
import austeretony.oxygen_teleportation.common.network.client.CPSyncFeeItemStack;
import austeretony.oxygen_teleportation.common.network.client.CPSyncInvitedPlayers;
import austeretony.oxygen_teleportation.common.network.client.CPWorldPointCreated;
import austeretony.oxygen_teleportation.common.network.client.CPWorldPointEdited;
import austeretony.oxygen_teleportation.common.network.client.CPWorldPointRemoved;
import austeretony.oxygen_teleportation.server.AbstractTeleportation;
import austeretony.oxygen_teleportation.server.CampInvitationRequest;
import austeretony.oxygen_teleportation.server.CampTeleportation;
import austeretony.oxygen_teleportation.server.PlayerTeleportation;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import austeretony.oxygen_teleportation.server.TeleportationRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayersDataManagerServer {
    private final TeleportationManagerServer manager;

    protected PlayersDataManagerServer(TeleportationManagerServer manager) {
        this.manager = manager;
    }

    public boolean isPlayerTeleporting(UUID playerUUID) {
        return OxygenHelperServer.getOxygenPlayerData((UUID)playerUUID).getTemporaryProcess(1000L) != null;
    }

    public void addTeleportation(AbstractTeleportation teleportation) {
        OxygenHelperServer.getOxygenPlayerData((UUID)CommonReference.getPersistentUUID((Entity)teleportation.playerMP)).addTemporaryProcess((TemporaryProcess)teleportation);
    }

    public void playerLoaded(EntityPlayerMP playerMP) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        TeleportationPlayerData playerData = this.manager.getPlayersDataContainer().getPlayerData(playerUUID);
        if (playerData == null) {
            playerData = this.manager.getPlayersDataContainer().createPlayerData(playerUUID);
            OxygenHelperServer.loadPersistentData((PersistentData)playerData);
        }
        if (TeleportationConfig.FEE_MODE.asInt() == 1) {
            OxygenMain.network().sendTo((Packet)new CPSyncFeeItemStack(), playerMP);
        }
        OxygenHelperServer.getPlayerSharedData((UUID)playerUUID).setByte(5, playerData.getJumpProfile().ordinal());
    }

    public void changeJumpProfile(EntityPlayerMP playerMP, TeleportationPlayerData.EnumJumpProfile profile) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_PLAYER_TELEPORTATION_USAGE.id(), (boolean)TeleportationConfig.ENABLE_PLAYER_TELEPORTATION.asBoolean())) {
            TeleportationPlayerData playerData = this.manager.getPlayersDataContainer().getPlayerData(playerUUID);
            playerData.setJumpProfile(profile);
            playerData.setChanged(true);
            OxygenHelperServer.getPlayerSharedData((UUID)playerUUID).setByte(5, profile.ordinal());
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.JUMP_PROFILE_CHANGED.ordinal(), (String[])new String[0]);
        }
    }

    public void moveToPlayer(EntityPlayerMP visitorPlayerMP, int targetIndex) {
        UUID visitorUUID = CommonReference.getPersistentUUID((Entity)visitorPlayerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)visitorUUID, (int)EnumTeleportationPrivilege.ALLOW_PLAYER_TELEPORTATION_USAGE.id(), (boolean)TeleportationConfig.ENABLE_PLAYER_TELEPORTATION.asBoolean()) && !this.isPlayerTeleporting(visitorUUID) && this.readyMoveToPlayer(visitorUUID) && OxygenHelperServer.isPlayerOnline((int)targetIndex)) {
            UUID targetUUID = OxygenHelperServer.getPlayerSharedData((int)targetIndex).getPlayerUUID();
            if (!visitorUUID.equals(targetUUID)) {
                TeleportationPlayerData.EnumJumpProfile targetJumpProfile = this.manager.getPlayersDataContainer().getPlayerData(targetUUID).getJumpProfile();
                switch (targetJumpProfile) {
                    case DISABLED: {
                        if (!PrivilegesProviderServer.getAsBoolean((UUID)visitorUUID, (int)EnumTeleportationPrivilege.ENABLE_TELEPORTATION_TO_ANY_PLAYER.id(), (boolean)false)) break;
                        this.move(visitorPlayerMP, visitorUUID, targetUUID);
                        break;
                    }
                    case FREE: {
                        this.move(visitorPlayerMP, visitorUUID, targetUUID);
                        break;
                    }
                    case REQUEST: {
                        if (PrivilegesProviderServer.getAsBoolean((UUID)visitorUUID, (int)EnumTeleportationPrivilege.ENABLE_TELEPORTATION_TO_ANY_PLAYER.id(), (boolean)false)) {
                            this.move(visitorPlayerMP, visitorUUID, targetUUID);
                            break;
                        }
                        EntityPlayerMP targetPlayerMP = CommonReference.playerByUUID((UUID)targetUUID);
                        OxygenHelperServer.sendRequest((EntityPlayerMP)visitorPlayerMP, (EntityPlayerMP)targetPlayerMP, (Notification)new TeleportationRequest(10, visitorUUID, CommonReference.getName((Entity)visitorPlayerMP)));
                    }
                }
            } else {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)visitorPlayerMP, (int)0, (int)EnumOxygenStatusMessage.REQUEST_RESET.ordinal(), (String[])new String[0]);
            }
        } else {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)visitorPlayerMP, (int)0, (int)EnumOxygenStatusMessage.REQUEST_RESET.ordinal(), (String[])new String[0]);
        }
    }

    public void move(EntityPlayerMP visitorPlayerMP, UUID visitorUUID, UUID targetUUID) {
        EntityPlayerMP targetPlayerMP = CommonReference.playerByUUID((UUID)targetUUID);
        if (!PrivilegesProviderServer.getAsBoolean((UUID)visitorUUID, (int)EnumTeleportationPrivilege.ENABLE_CROSS_DIM_TELEPORTATION.id(), (boolean)TeleportationConfig.ENABLE_CROSS_DIM_TELEPORTATION.asBoolean()) && visitorPlayerMP.field_71093_bK != targetPlayerMP.field_71093_bK) {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)visitorPlayerMP, (int)1, (int)EnumTeleportationStatusMessage.CROSS_DIM_TELEPORTSTION_DISABLED.ordinal(), (String[])new String[0]);
            return;
        }
        this.addTeleportation(new PlayerTeleportation(visitorPlayerMP, targetPlayerMP));
    }

    private boolean readyMoveToPlayer(UUID playerUUID) {
        return System.currentTimeMillis() >= this.manager.getPlayersDataContainer().getPlayerData(playerUUID).getCooldownData().getNextJumpTime();
    }

    public void moveToCamp(EntityPlayerMP playerMP, long pointId) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean())) {
            WorldPoint camp = this.getCamp(playerUUID, pointId);
            if (camp != null) {
                this.move(camp, playerUUID, playerMP);
            } else if (this.haveInvitation(playerUUID, pointId)) {
                this.move(this.manager.getSharedCampsContainer().getCamp(pointId), playerUUID, playerMP);
            }
        }
    }

    public void moveToFavoriteCamp(EntityPlayerMP playerMP, long pointId) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean()) && PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ENABLE_FAVORITE_CAMP.id(), (boolean)TeleportationConfig.ENABLE_FAVORITE_CAMP.asBoolean())) {
            WorldPoint camp = this.getCamp(playerUUID, pointId);
            if (camp != null) {
                this.move(camp, playerUUID, playerMP);
            } else if (this.haveInvitation(playerUUID, pointId)) {
                this.move(this.manager.getSharedCampsContainer().getCamp(pointId), playerUUID, playerMP);
            }
        }
    }

    private void move(WorldPoint worldPoint, UUID playerUUID, EntityPlayerMP playerMP) {
        if (this.campAvailable(worldPoint, playerUUID) && !this.isPlayerTeleporting(playerUUID) && this.readyMoveToCamp(playerUUID)) {
            if (!PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ENABLE_CROSS_DIM_TELEPORTATION.id(), (boolean)TeleportationConfig.ENABLE_CROSS_DIM_TELEPORTATION.asBoolean()) && playerMP.field_71093_bK != worldPoint.getDimensionId()) {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.CROSS_DIM_TELEPORTSTION_DISABLED.ordinal(), (String[])new String[0]);
                return;
            }
            this.addTeleportation(new CampTeleportation(playerMP, worldPoint));
        }
    }

    public void createCamp(EntityPlayerMP playerMP, String name, String description) {
        TeleportationPlayerData playerData;
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean()) && (playerData = this.manager.getPlayersDataContainer().getPlayerData(playerUUID)).getCampsAmount() < PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumTeleportationPrivilege.CAMPS_MAX_AMOUNT.id(), (int)TeleportationConfig.CAMPS_MAX_AMOUNT.asInt())) {
            if (name.isEmpty()) {
                name = String.format("Camp #%d", playerData.getCampsAmount() + 1);
            }
            if ((name = name.trim()).length() > 20) {
                name = name.substring(0, 20);
            }
            if (name.isEmpty()) {
                name = String.format("Camp #%d", playerData.getCampsAmount() + 1);
            }
            if ((description = description.trim()).length() > 400) {
                description = description.substring(0, 20);
            }
            WorldPoint camp = new WorldPoint(playerData.createId(TimeHelperServer.getCurrentMillis()), playerUUID, CommonReference.getName((Entity)playerMP), name, description, playerMP.field_71093_bK, (float)playerMP.field_70165_t, (float)playerMP.field_70163_u, (float)playerMP.field_70161_v, playerMP.field_70759_as, playerMP.field_70125_A);
            playerData.addCamp(camp);
            playerData.setChanged(true);
            OxygenMain.network().sendTo((Packet)new CPWorldPointCreated(WorldPoint.EnumWorldPoint.CAMP, camp), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.CAMP_CREATED.ordinal(), (String[])new String[0]);
        }
    }

    public void removeCamp(EntityPlayerMP playerMP, long pointId) {
        WorldPoint camp;
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean()) && (camp = this.getCamp(playerUUID, pointId)) != null && camp.isOwner(playerUUID)) {
            TeleportationPlayerData playerData = this.manager.getPlayersDataContainer().getPlayerData(playerUUID);
            playerData.removeCamp(pointId);
            playerData.setChanged(true);
            this.manager.getImagesLoader().removeCampPreviewImageAsync(playerUUID, pointId);
            if (this.manager.getSharedCampsContainer().haveInvitedPlayers(playerUUID, pointId)) {
                this.manager.getSharedCampsContainer().removeCamp(playerUUID, pointId);
                this.manager.getSharedCampsContainer().setChanged(true);
            }
            OxygenMain.network().sendTo((Packet)new CPWorldPointRemoved(WorldPoint.EnumWorldPoint.CAMP, camp.getId()), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.CAMP_REMOVED.ordinal(), (String[])new String[0]);
        }
    }

    public void setFavoriteCamp(EntityPlayerMP playerMP, long pointId) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        TeleportationPlayerData playerData = this.manager.getPlayersDataContainer().getPlayerData(playerUUID);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean()) && PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ENABLE_FAVORITE_CAMP.id(), (boolean)TeleportationConfig.ENABLE_FAVORITE_CAMP.asBoolean()) && (playerData.getCamp(pointId) != null || this.manager.getSharedCampsContainer().haveInvitation(playerUUID, pointId)) && pointId != playerData.getFavoriteCampId()) {
            playerData.setFavoriteCampId(pointId);
            playerData.setChanged(true);
            OxygenMain.network().sendTo((Packet)new CPFavoriteCampUpdated(pointId), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.FAVORITE_CAMP_SET.ordinal(), (String[])new String[0]);
        }
    }

    public void changeCampLockState(EntityPlayerMP playerMP, long pointId, boolean flag) {
        WorldPoint camp;
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean()) && (camp = this.getCamp(playerUUID, pointId)) != null && camp.isOwner(playerUUID)) {
            TeleportationPlayerData playerData = this.manager.getPlayersDataContainer().getPlayerData(playerUUID);
            camp.setLocked(flag);
            camp.setId(playerData.createId(pointId));
            playerData.addCamp(camp);
            if (playerData.getFavoriteCampId() == pointId) {
                playerData.setFavoriteCampId(camp.getId());
            }
            playerData.removeCamp(pointId);
            playerData.setChanged(true);
            this.manager.getImagesLoader().renameCampPreviewImageAsync(playerUUID, pointId, camp.getId());
            if (this.manager.getSharedCampsContainer().haveInvitedPlayers(playerUUID, pointId)) {
                this.manager.getSharedCampsContainer().replaceCamp(playerUUID, pointId, camp);
                this.manager.getSharedCampsContainer().setChanged(true);
            }
            OxygenMain.network().sendTo((Packet)new CPWorldPointEdited(WorldPoint.EnumWorldPoint.CAMP, pointId, camp, false), playerMP);
            if (flag) {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.CAMP_LOCKED.ordinal(), (String[])new String[0]);
            } else {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.CAMP_UNLOCKED.ordinal(), (String[])new String[0]);
            }
        }
    }

    public void editCamp(EntityPlayerMP playerMP, long pointId, String name, String description, boolean updatePosition, boolean updateImage) {
        WorldPoint camp;
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean()) && (camp = this.getCamp(playerUUID, pointId)) != null && camp.isOwner(playerUUID)) {
            TeleportationPlayerData playerData = this.manager.getPlayersDataContainer().getPlayerData(playerUUID);
            long newPointId = playerData.createId(pointId);
            if ((name = name.trim()).length() > 20) {
                name = name.substring(0, 20);
            }
            if (name.isEmpty()) {
                name = "Camp";
            }
            if ((description = description.trim()).length() > 400) {
                description = description.substring(0, 20);
            }
            camp.setName(name);
            camp.setDescription(description);
            if (updatePosition) {
                camp.setPosition((float)playerMP.field_70165_t, (float)playerMP.field_70163_u, (float)playerMP.field_70161_v, playerMP.field_71093_bK, playerMP.field_70759_as, playerMP.field_70125_A);
            }
            if (updateImage) {
                this.manager.getImagesLoader().removeCampPreviewImage(playerUUID, pointId);
            } else {
                this.manager.getImagesLoader().renameCampPreviewImageAsync(playerUUID, pointId, newPointId);
            }
            camp.setId(newPointId);
            playerData.addCamp(camp);
            if (playerData.getFavoriteCampId() == pointId) {
                playerData.setFavoriteCampId(newPointId);
            }
            playerData.removeCamp(pointId);
            playerData.setChanged(true);
            if (this.manager.getSharedCampsContainer().haveInvitedPlayers(playerUUID, pointId)) {
                this.manager.getSharedCampsContainer().replaceCamp(playerUUID, pointId, camp);
                this.manager.getSharedCampsContainer().setChanged(true);
            }
            OxygenMain.network().sendTo((Packet)new CPWorldPointEdited(WorldPoint.EnumWorldPoint.CAMP, pointId, camp, updateImage), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.CAMP_EDITED.ordinal(), (String[])new String[0]);
        }
    }

    public void invitePlayer(EntityPlayerMP playerMP, long pointId, UUID playerUUID) {
        WorldPoint camp;
        UUID ownerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (TeleportationConfig.ENABLE_CAMP_INVITATIONS.asBoolean() && PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean()) && (camp = this.getCamp(ownerUUID, pointId)) != null && camp.isOwner(ownerUUID) && OxygenHelperServer.isPlayerOnline((UUID)playerUUID) && !this.manager.getSharedCampsContainer().haveInvitation(playerUUID, pointId) && !playerUUID.equals(ownerUUID)) {
            if (this.manager.getSharedCampsContainer().getInvitedPlayersAmountForCamp(playerUUID, pointId) < TeleportationConfig.MAX_INVITED_PLAYERS_PER_CAMP.asInt()) {
                EntityPlayerMP invitedPlayerMP = CommonReference.playerByUUID((UUID)playerUUID);
                OxygenHelperServer.sendRequest((EntityPlayerMP)playerMP, (EntityPlayerMP)invitedPlayerMP, (Notification)new CampInvitationRequest(11, ownerUUID, CommonReference.getName((Entity)playerMP), pointId, camp.getName()));
            } else {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)0, (int)EnumOxygenStatusMessage.REQUEST_RESET.ordinal(), (String[])new String[0]);
            }
        }
    }

    public void uninvitePlayer(EntityPlayerMP playerMP, long pointId, UUID playerUUID) {
        WorldPoint camp;
        UUID ownerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (TeleportationConfig.ENABLE_CAMP_INVITATIONS.asBoolean() && PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumTeleportationPrivilege.ALLOW_CAMPS_USAGE.id(), (boolean)TeleportationConfig.ENABLE_CAMPS.asBoolean()) && (camp = this.getCamp(ownerUUID, pointId)) != null && camp.isOwner(ownerUUID) && this.manager.getSharedCampsContainer().haveInvitation(playerUUID, pointId)) {
            this.manager.getSharedCampsContainer().uninvite(ownerUUID, pointId, playerUUID);
            this.manager.getSharedCampsContainer().setChanged(true);
            OxygenHelperServer.removeObservedPlayer((UUID)ownerUUID, (UUID)playerUUID);
            OxygenMain.network().sendTo((Packet)new CPPlayerUninvited(pointId, playerUUID), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.UNINVITED.ordinal(), (String[])new String[0]);
        }
    }

    public void leaveCamp(EntityPlayerMP playerMP, long pointId) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (this.manager.getSharedCampsContainer().haveInvitation(playerUUID, pointId)) {
            UUID ownerUUID = this.manager.getSharedCampsContainer().getCampOwner(pointId);
            this.manager.getSharedCampsContainer().uninvite(ownerUUID, pointId, playerUUID);
            this.manager.getSharedCampsContainer().setChanged(true);
            OxygenHelperServer.removeObservedPlayer((UUID)ownerUUID, (UUID)playerUUID);
            TeleportationPlayerData playerData = this.manager.getPlayersDataContainer().getPlayerData(playerUUID);
            if (playerData.getFavoriteCampId() == pointId) {
                playerData.setFavoriteCampId(0L);
            }
            playerData.setChanged(true);
            OxygenMain.network().sendTo((Packet)new CPWorldPointRemoved(WorldPoint.EnumWorldPoint.CAMP, pointId), playerMP);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)1, (int)EnumTeleportationStatusMessage.CAMP_LEFT.ordinal(), (String[])new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncInvitationsData(EntityPlayerMP playerMP) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (this.manager.getSharedCampsContainer().haveInvitedPlayers(playerUUID)) {
            ByteBuf buffer = null;
            try {
                buffer = Unpooled.buffer();
                this.manager.getSharedCampsContainer().getInvitationsContainer(playerUUID).write(buffer);
                byte[] compressed = new byte[buffer.writerIndex()];
                buffer.readBytes(compressed);
                OxygenMain.network().sendTo((Packet)new CPSyncInvitedPlayers(compressed), playerMP);
            }
            finally {
                if (buffer != null) {
                    buffer.release();
                }
            }
        }
    }

    private boolean haveInvitation(UUID playerUUID, long pointId) {
        return this.manager.getSharedCampsContainer().haveInvitation(playerUUID, pointId) && this.manager.getSharedCampsContainer().isCampExist(pointId);
    }

    @Nullable
    private WorldPoint getCamp(UUID playerUUID, long pointId) {
        return this.manager.getPlayersDataContainer().getPlayerData(playerUUID).getCamp(pointId);
    }

    private boolean campAvailable(WorldPoint worldPoint, UUID playerUUID) {
        return !worldPoint.isLocked() || worldPoint.isOwner(playerUUID);
    }

    private boolean readyMoveToCamp(UUID playerUUID) {
        return TimeHelperServer.getCurrentMillis() >= this.manager.getPlayersDataContainer().getPlayerData(playerUUID).getCooldownData().getNextCampTime();
    }
}

