/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.ConcurrentSetWrapper;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.WorldPoint;
import austeretony.oxygen_teleportation.server.InvitationsContainerServer;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class SharedCampsContainerServer
extends AbstractPersistentData {
    private final Map<Long, WorldPoint> cache = new ConcurrentHashMap<Long, WorldPoint>();
    private final Map<Long, UUID> access = new ConcurrentHashMap<Long, UUID>();
    private final Map<UUID, ConcurrentSetWrapper<Long>> invited = new ConcurrentHashMap<UUID, ConcurrentSetWrapper<Long>>();
    private final Map<UUID, InvitationsContainerServer> owners = new ConcurrentHashMap<UUID, InvitationsContainerServer>();

    protected SharedCampsContainerServer() {
    }

    @Nullable
    public UUID getCampOwner(long pointId) {
        return this.access.get(pointId);
    }

    public boolean isCampExist(long pointId) {
        return this.cache.containsKey(pointId);
    }

    @Nullable
    public WorldPoint getCamp(long pointId) {
        return this.cache.get(pointId);
    }

    public void removeCamp(UUID playerUUID, long pointId) {
        this.cache.remove(pointId);
        this.access.remove(pointId);
        InvitationsContainerServer invitations = this.owners.get(playerUUID);
        for (UUID invitedUUID : invitations.access.get((Object)Long.valueOf((long)pointId)).set) {
            invitations.invitedPlayers.get(invitedUUID).remove((Object)pointId);
            invitations.access.remove(pointId);
            this.invited.get(invitedUUID).remove((Object)pointId);
        }
    }

    public void replaceCamp(UUID playerUUID, long oldPointId, WorldPoint worldPoint) {
        this.cache.remove(oldPointId);
        this.cache.put(worldPoint.getId(), worldPoint);
        this.access.remove(oldPointId);
        this.access.put(worldPoint.getId(), playerUUID);
        InvitationsContainerServer invitations = this.owners.get(playerUUID);
        invitations.updateId();
        ConcurrentSetWrapper<UUID> players = invitations.access.get(oldPointId);
        for (UUID invitedUUID : players.set) {
            ConcurrentSetWrapper<Long> campsOwner = invitations.invitedPlayers.get(invitedUUID);
            campsOwner.remove((Object)oldPointId);
            campsOwner.add((Object)worldPoint.getId());
            ConcurrentSetWrapper<Long> campsInvited = this.invited.get(invitedUUID);
            campsInvited.remove((Object)oldPointId);
            campsInvited.add((Object)worldPoint.getId());
        }
        invitations.access.put(worldPoint.getId(), players);
        invitations.access.remove(oldPointId);
    }

    public boolean haveInvitations(UUID playerUUID) {
        return this.invited.containsKey(playerUUID) && !this.invited.get(playerUUID).isEmpty();
    }

    public boolean haveInvitation(UUID playerUUID, long pointId) {
        return this.invited.containsKey(playerUUID) && this.invited.get(playerUUID).contains((Object)pointId);
    }

    public int getInvitationsAmount(UUID playerUUID) {
        if (!this.invited.containsKey(playerUUID)) {
            return 0;
        }
        return this.invited.get(playerUUID).size();
    }

    public Set<Long> getInvitations(UUID playerUUID) {
        return this.invited.get((Object)playerUUID).set;
    }

    public boolean haveInvitedPlayers(UUID playerUUID) {
        return this.owners.containsKey(playerUUID) && !this.owners.get((Object)playerUUID).invitedPlayers.isEmpty();
    }

    public boolean haveInvitedPlayers(UUID playerUUID, long pointId) {
        return this.owners.containsKey(playerUUID) && this.owners.get((Object)playerUUID).access.containsKey(pointId);
    }

    public int getInvitedPlayersAmountForCamp(UUID playerUUID, long pointId) {
        if (!this.owners.containsKey(playerUUID)) {
            return 0;
        }
        InvitationsContainerServer invitations = this.owners.get(playerUUID);
        if (!invitations.access.containsKey(pointId)) {
            return 0;
        }
        return invitations.access.get(pointId).size();
    }

    @Nullable
    public InvitationsContainerServer getInvitationsContainer(UUID playerUUID) {
        return this.owners.get(playerUUID);
    }

    public void invite(UUID ownerUUID, long pointId, UUID invitedUUID) {
        ConcurrentSetWrapper camps;
        if (!this.isCampExist(pointId)) {
            this.cache.put(pointId, TeleportationManagerServer.instance().getPlayersDataContainer().getPlayerData(ownerUUID).getCamp(pointId));
        }
        if (!this.access.containsKey(pointId)) {
            this.access.put(pointId, ownerUUID);
        }
        if (!this.invited.containsKey(invitedUUID)) {
            camps = new ConcurrentSetWrapper();
            camps.add((Object)pointId);
            this.invited.put(invitedUUID, (ConcurrentSetWrapper<Long>)camps);
        } else {
            this.invited.get(invitedUUID).add((Object)pointId);
        }
        if (!this.owners.containsKey(ownerUUID)) {
            InvitationsContainerServer invitations = new InvitationsContainerServer();
            invitations.updateId();
            camps = new ConcurrentSetWrapper();
            camps.add((Object)pointId);
            invitations.invitedPlayers.put(invitedUUID, (ConcurrentSetWrapper<Long>)camps);
            ConcurrentSetWrapper players = new ConcurrentSetWrapper();
            players.add((Object)invitedUUID);
            invitations.access.put(pointId, (ConcurrentSetWrapper<UUID>)players);
            this.owners.put(ownerUUID, invitations);
        } else {
            InvitationsContainerServer invitations = this.owners.get(ownerUUID);
            invitations.updateId();
            if (!invitations.invitedPlayers.containsKey(invitedUUID)) {
                camps = new ConcurrentSetWrapper();
                camps.add((Object)pointId);
                invitations.invitedPlayers.put(invitedUUID, (ConcurrentSetWrapper<Long>)camps);
            } else {
                invitations.invitedPlayers.get(invitedUUID).add((Object)pointId);
            }
            if (!invitations.access.containsKey(pointId)) {
                ConcurrentSetWrapper players = new ConcurrentSetWrapper();
                players.add((Object)invitedUUID);
                invitations.access.put(pointId, (ConcurrentSetWrapper<UUID>)players);
            } else {
                invitations.access.get(pointId).add((Object)invitedUUID);
            }
        }
    }

    public void uninvite(UUID ownerUUID, long pointId, UUID invitedUUID) {
        this.invited.get(invitedUUID).remove((Object)pointId);
        InvitationsContainerServer invitations = this.owners.get(ownerUUID);
        invitations.updateId();
        invitations.invitedPlayers.get(invitedUUID).remove((Object)pointId);
        invitations.access.get(pointId).remove((Object)invitedUUID);
    }

    public String getDisplayName() {
        return "teleportation:shared_camps_server";
    }

    public String getPath() {
        return OxygenHelperServer.getDataFolder() + "/server/world/teleportation/shared_camps.dat";
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((int)this.cache.size(), (OutputStream)bos);
        for (WorldPoint worldPoint : this.cache.values()) {
            worldPoint.write(bos);
        }
        StreamUtils.write((int)this.invited.size(), (OutputStream)bos);
        for (Map.Entry entry : this.invited.entrySet()) {
            StreamUtils.write((UUID)((UUID)entry.getKey()), (OutputStream)bos);
            StreamUtils.write((short)((short)((ConcurrentSetWrapper)entry.getValue()).size()), (OutputStream)bos);
            Iterator<Object> iterator = ((ConcurrentSetWrapper)entry.getValue()).set.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                StreamUtils.write((long)l, (OutputStream)bos);
            }
        }
        StreamUtils.write((int)this.owners.size(), (OutputStream)bos);
        for (Map.Entry entry : this.owners.entrySet()) {
            StreamUtils.write((UUID)((UUID)entry.getKey()), (OutputStream)bos);
            StreamUtils.write((long)((InvitationsContainerServer)entry.getValue()).getId(), (OutputStream)bos);
            StreamUtils.write((short)((short)((InvitationsContainerServer)entry.getValue()).invitedPlayers.size()), (OutputStream)bos);
            for (Map.Entry entry2 : ((InvitationsContainerServer)entry.getValue()).invitedPlayers.entrySet()) {
                StreamUtils.write((UUID)((UUID)entry2.getKey()), (OutputStream)bos);
                StreamUtils.write((short)((short)((ConcurrentSetWrapper)entry2.getValue()).size()), (OutputStream)bos);
                Iterator iterator = ((ConcurrentSetWrapper)entry2.getValue()).set.iterator();
                while (iterator.hasNext()) {
                    long pointId = (Long)iterator.next();
                    StreamUtils.write((long)pointId, (OutputStream)bos);
                }
            }
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int j;
        ConcurrentSetWrapper camps;
        int sizeInner;
        UUID playerUUID;
        int i;
        int sizeOuter = StreamUtils.readInt((InputStream)bis);
        for (i = 0; i < sizeOuter; ++i) {
            WorldPoint worldPoint = WorldPoint.read(bis);
            this.cache.put(worldPoint.getId(), worldPoint);
        }
        sizeOuter = StreamUtils.readInt((InputStream)bis);
        for (i = 0; i < sizeOuter; ++i) {
            playerUUID = StreamUtils.readUUID((InputStream)bis);
            sizeInner = StreamUtils.readShort((InputStream)bis);
            camps = new ConcurrentSetWrapper();
            for (j = 0; j < sizeInner; ++j) {
                camps.add((Object)StreamUtils.readLong((InputStream)bis));
            }
            this.invited.put(playerUUID, (ConcurrentSetWrapper<Long>)camps);
        }
        sizeOuter = StreamUtils.readInt((InputStream)bis);
        for (i = 0; i < sizeOuter; ++i) {
            InvitationsContainerServer invitations = new InvitationsContainerServer();
            playerUUID = StreamUtils.readUUID((InputStream)bis);
            invitations.setId(StreamUtils.readLong((InputStream)bis));
            sizeInner = StreamUtils.readShort((InputStream)bis);
            for (j = 0; j < sizeInner; ++j) {
                UUID invitedUUID = StreamUtils.readUUID((InputStream)bis);
                int sizeCamps = StreamUtils.readShort((InputStream)bis);
                camps = new ConcurrentSetWrapper();
                for (int k = 0; k < sizeCamps; ++k) {
                    long pointId = StreamUtils.readLong((InputStream)bis);
                    camps.add((Object)pointId);
                    this.access.put(pointId, playerUUID);
                }
                invitations.invitedPlayers.put(invitedUUID, (ConcurrentSetWrapper<Long>)camps);
            }
            this.owners.put(playerUUID, invitations);
        }
        for (InvitationsContainerServer invitation : this.owners.values()) {
            for (Map.Entry<UUID, ConcurrentSetWrapper<Long>> entry : invitation.invitedPlayers.entrySet()) {
                Iterator iterator = entry.getValue().set.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    if (!invitation.access.containsKey(id)) {
                        ConcurrentSetWrapper players = new ConcurrentSetWrapper();
                        players.add((Object)entry.getKey());
                        invitation.access.put(id, (ConcurrentSetWrapper<UUID>)players);
                        continue;
                    }
                    invitation.access.get(id).add((Object)entry.getKey());
                }
            }
        }
    }

    public void reset() {
        this.cache.clear();
        this.access.clear();
        this.invited.clear();
        this.owners.clear();
    }
}

