/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.OxygenHelperCommon;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class TeleportationLoaderServer {
    public static void loadFeeItemStackAsync() {
        OxygenHelperServer.addIOTask(() -> {
            String folder = OxygenHelperCommon.getConfigFolder() + "data/server/teleportation/fee_itemstack.json";
            Path path = Paths.get(folder, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    TeleportationManagerServer.instance().setFeeStack(ItemStackWrapper.fromJson((JsonObject)JsonUtils.getExternalJsonData((String)folder).getAsJsonObject()));
                }
                catch (IOException exception) {
                    OxygenMain.LOGGER.error("[Teleportation] Fee stack data loading failed! Path: {}", (Object)folder);
                    exception.printStackTrace();
                }
            } else {
                TeleportationManagerServer.instance().setFeeStack(ItemStackWrapper.of((ItemStack)new ItemStack(Items.field_151166_bC)));
            }
        });
    }

    public static void saveFeeItemStackAsync() {
        OxygenHelperServer.addIOTask(() -> {
            String folder = OxygenHelperCommon.getConfigFolder() + "data/server/teleportation/fee_itemstack.json";
            Path path = Paths.get(folder, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            try {
                JsonUtils.createExternalJsonFile((String)folder, (JsonElement)TeleportationManagerServer.instance().getFeeStackWrapper().toJson());
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Teleportation] Fee stack data saving failed! Path: {}", (Object)folder);
                exception.printStackTrace();
            }
        });
    }
}

