/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.persistent.PersistentData;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.server.ImagesLoaderServer;
import austeretony.oxygen_teleportation.server.ImagesManagerServer;
import austeretony.oxygen_teleportation.server.LocationsContainerServer;
import austeretony.oxygen_teleportation.server.LocationsManagerServer;
import austeretony.oxygen_teleportation.server.PlayersDataContainerServer;
import austeretony.oxygen_teleportation.server.PlayersDataManagerServer;
import austeretony.oxygen_teleportation.server.SharedCampsContainerServer;
import austeretony.oxygen_teleportation.server.TeleportationLoaderServer;
import net.minecraft.entity.player.EntityPlayerMP;

public class TeleportationManagerServer {
    private static TeleportationManagerServer instance;
    private final PlayersDataContainerServer playersDataContainer = new PlayersDataContainerServer();
    private final PlayersDataManagerServer playersDataManager;
    private final SharedCampsContainerServer sharedCampsContainer = new SharedCampsContainerServer();
    private final LocationsContainerServer locationsContainer = new LocationsContainerServer();
    private final LocationsManagerServer locationsManager;
    private final ImagesManagerServer imagesManager;
    private final ImagesLoaderServer imagesLoader;
    private ItemStackWrapper feeStackWrapper;

    private TeleportationManagerServer() {
        this.playersDataManager = new PlayersDataManagerServer(this);
        this.locationsManager = new LocationsManagerServer(this);
        this.imagesManager = new ImagesManagerServer(this);
        this.imagesLoader = new ImagesLoaderServer(this);
    }

    private void registerPersistentData() {
        OxygenHelperServer.registerPersistentData(this.playersDataContainer::save);
        OxygenHelperServer.registerPersistentData((PersistentData)this.sharedCampsContainer);
        OxygenHelperServer.registerPersistentData((PersistentData)this.locationsContainer);
    }

    public static void create() {
        if (instance == null) {
            instance = new TeleportationManagerServer();
            instance.registerPersistentData();
        }
    }

    public static TeleportationManagerServer instance() {
        return instance;
    }

    public PlayersDataContainerServer getPlayersDataContainer() {
        return this.playersDataContainer;
    }

    public PlayersDataManagerServer getPlayersDataManager() {
        return this.playersDataManager;
    }

    public SharedCampsContainerServer getSharedCampsContainer() {
        return this.sharedCampsContainer;
    }

    public LocationsContainerServer getLocationsContainer() {
        return this.locationsContainer;
    }

    public LocationsManagerServer getLocationsManager() {
        return this.locationsManager;
    }

    public ImagesManagerServer getImagesManager() {
        return this.imagesManager;
    }

    public ImagesLoaderServer getImagesLoader() {
        return this.imagesLoader;
    }

    public void worldLoaded() {
        OxygenHelperServer.loadPersistentDataAsync((PersistentData)this.sharedCampsContainer);
        OxygenHelperServer.loadPersistentDataAsync((PersistentData)this.locationsContainer);
        if (TeleportationConfig.FEE_MODE.asInt() == 1) {
            TeleportationLoaderServer.loadFeeItemStackAsync();
        }
        this.imagesLoader.loadLocationPreviewImagesAsync();
    }

    public void playerLoaded(EntityPlayerMP playerMP) {
        this.playersDataManager.playerLoaded(playerMP);
    }

    public void setFeeStack(ItemStackWrapper stackWrapper) {
        this.feeStackWrapper = stackWrapper;
    }

    public ItemStackWrapper getFeeStackWrapper() {
        return this.feeStackWrapper;
    }
}

