/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_teleportation.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.notification.AbstractNotification;
import austeretony.oxygen_core.common.notification.EnumNotification;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_teleportation.common.config.TeleportationConfig;
import austeretony.oxygen_teleportation.common.main.EnumTeleportationStatusMessage;
import austeretony.oxygen_teleportation.server.TeleportationManagerServer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class TeleportationRequest
extends AbstractNotification {
    public final int index;
    public final String senderUsername;
    public final UUID senderUUID;

    public TeleportationRequest(int index, UUID senderUUID, String senderUsername) {
        this.index = index;
        this.senderUUID = senderUUID;
        this.senderUsername = senderUsername;
    }

    public EnumNotification getType() {
        return EnumNotification.REQUEST;
    }

    public String getDescription() {
        return "oxygen_teleportation.jump.request";
    }

    public String[] getArguments() {
        return new String[]{this.senderUsername};
    }

    public int getIndex() {
        return this.index;
    }

    public int getExpireTimeSeconds() {
        return TeleportationConfig.PLAYER_TELEPORTATION_REQUEST_EXPIRE_TIME.asInt();
    }

    public void process() {
    }

    public void accepted(EntityPlayer player) {
        if (OxygenHelperServer.isPlayerOnline((UUID)this.senderUUID)) {
            EntityPlayerMP senderPlayerMP = CommonReference.playerByUUID((UUID)this.senderUUID);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)((EntityPlayerMP)player), (int)1, (int)EnumTeleportationStatusMessage.JUMP_REQUEST_ACCEPTED_TARGET.ordinal(), (String[])new String[0]);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)senderPlayerMP, (int)1, (int)EnumTeleportationStatusMessage.JUMP_REQUEST_ACCEPTED_SENDER.ordinal(), (String[])new String[0]);
            TeleportationManagerServer.instance().getPlayersDataManager().move(senderPlayerMP, this.senderUUID, CommonReference.getPersistentUUID((Entity)player));
        } else {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)((EntityPlayerMP)player), (int)1, (int)EnumTeleportationStatusMessage.JUMP_REQUEST_VISITOR_OFFLINE.ordinal(), (String[])new String[0]);
        }
    }

    public void rejected(EntityPlayer player) {
        if (OxygenHelperServer.isPlayerOnline((UUID)this.senderUUID)) {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)CommonReference.playerByUUID((UUID)this.senderUUID), (int)1, (int)EnumTeleportationStatusMessage.JUMP_REQUEST_REJECTED_SENDER.ordinal(), (String[])new String[0]);
        }
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)((EntityPlayerMP)player), (int)1, (int)EnumTeleportationStatusMessage.JUMP_REQUEST_REJECTED_TARGET.ordinal(), (String[])new String[0]);
    }

    public void expired() {
    }
}

