/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.zoom;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Mouse;

public enum WiZoom {
    INSTANCE;

    public static final String VERSION = "1.1";
    private KeyBinding zoomKey;
    private final float defaultLevel = 3.0f;
    private Float currentLevel;
    private Float defaultMouseSensitivity;

    public void initialize() {
        System.out.println("Starting WI Zoom...");
        this.zoomKey = new KeyBinding("wi-zoom.zoom", 47, "WI Zoom");
        ClientRegistry.registerKeyBinding((KeyBinding)this.zoomKey);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public float changeFovBasedOnZoom(float fov) {
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (this.currentLevel == null) {
            this.currentLevel = Float.valueOf(3.0f);
        }
        if (!this.isZooming()) {
            this.currentLevel = Float.valueOf(3.0f);
            if (this.defaultMouseSensitivity != null) {
                gameSettings.field_74341_c = this.defaultMouseSensitivity.floatValue();
                this.defaultMouseSensitivity = null;
            }
            return fov;
        }
        if (this.defaultMouseSensitivity == null) {
            this.defaultMouseSensitivity = Float.valueOf(gameSettings.field_74341_c);
        }
        gameSettings.field_74341_c = this.defaultMouseSensitivity.floatValue() * (fov / this.currentLevel.floatValue() / fov);
        return fov / this.currentLevel.floatValue();
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseInputEvent event) {
        int amount;
        if (!this.isZooming()) {
            return;
        }
        if (this.currentLevel == null) {
            this.currentLevel = Float.valueOf(3.0f);
        }
        if ((amount = Mouse.getDWheel()) > 0) {
            this.currentLevel = Float.valueOf(this.currentLevel.floatValue() * 1.1f);
        } else if (amount < 0) {
            this.currentLevel = Float.valueOf(this.currentLevel.floatValue() * 0.9f);
        }
        this.currentLevel = Float.valueOf(MathHelper.func_76131_a((float)this.currentLevel.floatValue(), (float)1.0f, (float)50.0f));
    }

    public boolean isZooming() {
        return this.zoomKey.func_151470_d();
    }
}

