/*
 * Decompiled with CFR 0.152.
 */
package com.trikzon.flora_doubling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.trikzon.flora_doubling.FloraDoubling;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class Config {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigBean read() {
        try (FileReader file = new FileReader(FloraDoubling.MOD_CONFIG_FILE);){
            Gson gson = new Gson();
            ConfigBean configBean = (ConfigBean)gson.fromJson((Reader)file, ConfigBean.class);
            return configBean;
        }
        catch (IOException e) {
            FloraDoubling.LOGGER.error("Failed to read from config file.");
            return null;
        }
    }

    public static void write(ConfigBean config) {
        if (!FloraDoubling.MOD_CONFIG_FILE.getParentFile().exists() && !FloraDoubling.MOD_CONFIG_FILE.getParentFile().mkdirs()) {
            FloraDoubling.LOGGER.error("Failed to write the config file as parent directories couldn't be made.");
        }
        try (FileWriter file = new FileWriter(FloraDoubling.MOD_CONFIG_FILE);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            file.write(gson.toJson((Object)config));
            file.flush();
        }
        catch (IOException e) {
            FloraDoubling.LOGGER.error("Failed to write the config file.");
        }
    }

    public static class ConfigBean {
        public ArrayList<String> doublingFlora = new ArrayList();
        public boolean dispenser = true;
        public boolean useSmallFlowersTag = true;
        public boolean useTallFlowersTag = true;
        public boolean allowWitherRoses = false;
    }
}

