/*
 * Decompiled with CFR 0.152.
 */
package com.trikzon.flora_doubling;

import com.trikzon.flora_doubling.Config;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.WitherRoseBlock;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="flora-doubling")
public class FloraDoubling {
    public static final String MOD_ID = "flora-doubling";
    public static final Logger LOGGER = LogManager.getLogger((String)"flora-doubling");
    public static final File MOD_CONFIG_FILE = new File("./config/flora-doubling.json");
    public static final ITag.INamedTag<Block> DOUBLING_FLORA_TAG = BlockTags.func_199894_a((String)"flora-doubling:doubling_flora");
    public static final ITag.INamedTag<Block> SMALL_FLOWERS_TAG = BlockTags.field_219746_E;
    public static final ITag.INamedTag<Block> TALL_FLOWERS_TAG = BlockTags.field_226148_H_;
    public static Config.ConfigBean CONFIG = new Config.ConfigBean();

    public FloraDoubling() {
        if (MOD_CONFIG_FILE.exists()) {
            Config.ConfigBean config = Config.read();
            if (config != null) {
                CONFIG = config;
            }
        } else {
            Config.write(CONFIG);
        }
        MinecraftForge.EVENT_BUS.addListener(this::onBoneMeal);
    }

    private void onBoneMeal(BonemealEvent event) {
        boolean success;
        if ((FloraDoubling.CONFIG.dispenser || !(event.getPlayer() instanceof FakePlayer)) && (success = this.grow(event.getStack(), event.getWorld(), event.getPos()))) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    private boolean grow(ItemStack stack, World world, BlockPos pos) {
        if (!(stack.func_77973_b() instanceof BoneMealItem)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        boolean success = FloraDoubling.isTargetFlower(block);
        if (success) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)block, 1));
        }
        return success;
    }

    public static boolean isTargetFlower(Block block) {
        return (block.getClass() != WitherRoseBlock.class || FloraDoubling.CONFIG.allowWitherRoses) && (DOUBLING_FLORA_TAG.func_230235_a_((Object)block) || FloraDoubling.CONFIG.doublingFlora.contains(block.getRegistryName().toString()) || SMALL_FLOWERS_TAG.func_230235_a_((Object)block) && FloraDoubling.CONFIG.useSmallFlowersTag || TALL_FLOWERS_TAG.func_230235_a_((Object)block) && FloraDoubling.CONFIG.useTallFlowersTag);
    }
}

