/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;

public abstract class GuiLayer
extends GuiParent {
    public final GuiStyle style;

    public GuiLayer(String name, int width, int height) {
        super(name, 0, 0, width, height);
        this.style = GuiStyle.getStyle(name);
    }

    @Override
    public void init() {
        this.create();
        super.init();
        this.initiateLayoutUpdate();
    }

    public void reinit() {
        super.init();
        this.initiateLayoutUpdate();
    }

    @Override
    public void initiateLayoutUpdate() {
        this.updateLayout();
    }

    public abstract void create();

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.GUI;
    }

    @Override
    public String getNestedName() {
        return "gui." + super.getNestedName();
    }

    @Override
    public GuiLayer getLayer() {
        return this;
    }

    @Override
    public GuiStyle getStyle() {
        return this.style;
    }

    public boolean closeLayerUsingEscape() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GameSettings getSettings() {
        return Minecraft.func_71410_x().field_71474_y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasGrayBackground() {
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.closeLayerUsingEscape()) {
                this.closeTopLayer();
            }
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == this.getSettings().field_151445_Q.getKey().func_197937_c()) {
            this.closeTopLayer();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLayer() {
        return true;
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public void setWidthLayout(int width) {
    }

    @Override
    public int getMinWidth() {
        return 0;
    }

    @Override
    public void setHeightLayout(int height) {
    }

    @Override
    public int getMinHeight() {
        return 0;
    }
}

