/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.handler;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.ContainerScreenIntegration;
import team.creative.creativecore.common.gui.sync.OpenGuiPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class GuiContainerHandler {
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"creativecore");
    private static HashMap<String, GuiContainerHandler> guihandlers = new HashMap();
    INamedContainerProvider provider;
    Supplier<ContainerType<ContainerIntegration>> type;

    public static <T extends CreativePacket> void registerGuiHandler(String handlerid, final GuiHandlerPlayer handler) {
        guihandlers.put(handlerid, handler);
        handler.type = CONTAINERS.register(handlerid, () -> new ContainerType<ContainerIntegration>(null){

            public ContainerIntegration create(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
                return new ContainerIntegration(this, windowId, playerInv.field_70458_d, handler.create(playerInv.field_70458_d));
            }

            public ContainerIntegration create(int windowId, PlayerInventory playerInv) {
                return new ContainerIntegration(this, windowId, playerInv.field_70458_d, handler.create(playerInv.field_70458_d));
            }
        });
        handler.provider = new SimpleNamedContainerProvider((id, inventory, player) -> {
            ContainerIntegration integration = new ContainerIntegration((ContainerType<ContainerIntegration>)((ContainerType)handler.type.get()), id, player, handler.create(player));
            return integration;
        }, (ITextComponent)new StringTextComponent(handlerid));
    }

    public static GuiContainerHandler getHandler(String id) {
        return guihandlers.get(id);
    }

    public static void openGui(PlayerEntity player, String name) {
        GuiContainerHandler handler = GuiContainerHandler.getHandler(name);
        if (handler != null) {
            if (player.field_70170_p.field_72995_K) {
                CreativeCore.NETWORK.sendToServer(new OpenGuiPacket(name));
            } else {
                player.func_213829_a(handler.provider);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        for (GuiContainerHandler handler : guihandlers.values()) {
            ScreenManager.func_216911_a(handler.type.get(), (ScreenManager.IScreenFactory)new ScreenManager.IScreenFactory<ContainerIntegration, ContainerScreenIntegration>(){

                public ContainerScreenIntegration create(ContainerIntegration container, PlayerInventory inventory, ITextComponent p_create_3_) {
                    return new ContainerScreenIntegration(container, inventory);
                }
            });
        }
    }

    public static abstract class GuiHandlerPlayer
    extends GuiContainerHandler {
        public abstract GuiLayer create(PlayerEntity var1);
    }
}

