/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.FoodStats;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.HungerHelper;

public class FoodHelper {
    public static boolean isFood(ItemStack itemStack) {
        return itemStack.func_77973_b().func_219967_s() != null;
    }

    public static boolean canConsume(ItemStack itemStack, PlayerEntity player) {
        if (!FoodHelper.isFood(itemStack)) {
            return false;
        }
        Food itemFood = itemStack.func_77973_b().func_219967_s();
        if (itemFood == null) {
            return false;
        }
        return player.func_71043_e(itemFood.func_221468_d());
    }

    public static FoodValues getDefaultFoodValues(ItemStack itemStack) {
        Food itemFood = itemStack.func_77973_b().func_219967_s();
        int hunger = itemFood != null ? itemFood.func_221466_a() : 0;
        float saturationModifier = itemFood != null ? itemFood.func_221469_b() : 0.0f;
        return new FoodValues(hunger, saturationModifier);
    }

    public static FoodValues getModifiedFoodValues(ItemStack itemStack, PlayerEntity player) {
        return FoodHelper.getDefaultFoodValues(itemStack);
    }

    public static boolean isRotten(ItemStack itemStack) {
        if (!FoodHelper.isFood(itemStack)) {
            return false;
        }
        for (Pair effect : itemStack.func_77973_b().func_219967_s().func_221464_f()) {
            if (effect.getFirst() == null || ((EffectInstance)effect.getFirst()).func_188419_a() == null || ((EffectInstance)effect.getFirst()).func_188419_a().func_220303_e() != EffectType.HARMFUL) continue;
            return true;
        }
        return false;
    }

    public static float getEstimatedHealthIncrement(ItemStack itemStack, FoodValues modifiedFoodValues, PlayerEntity player) {
        if (!FoodHelper.isFood(itemStack)) {
            return 0.0f;
        }
        if (!player.func_70996_bM()) {
            return 0.0f;
        }
        FoodStats stats = player.func_71024_bL();
        World world = player.func_130014_f_();
        int foodLevel = Math.min(stats.func_75116_a() + modifiedFoodValues.hunger, 20);
        float healthIncrement = 0.0f;
        if ((float)foodLevel >= 18.0f && world != null && world.func_82736_K().func_223586_b(GameRules.field_223606_i)) {
            float saturationLevel = Math.min(stats.func_75115_e() + modifiedFoodValues.getSaturationIncrement(), (float)foodLevel);
            float exhaustionLevel = HungerHelper.getExhaustion(player);
            healthIncrement = FoodHelper.getEstimatedHealthIncrement(foodLevel, saturationLevel, exhaustionLevel);
        }
        for (Pair effect : itemStack.func_77973_b().func_219967_s().func_221464_f()) {
            EffectInstance effectInstance = (EffectInstance)effect.getFirst();
            if (effectInstance == null || effectInstance.func_188419_a() != Effects.field_76428_l) continue;
            int amplifier = effectInstance.func_76458_c();
            int duration = effectInstance.func_76459_b();
            healthIncrement += (float)Math.floor(duration / (50 >> amplifier));
            break;
        }
        return healthIncrement;
    }

    public static float getEstimatedHealthIncrement(int foodLevel, float saturationLevel, float exhaustionLevel) {
        float health = 0.0f;
        float exhaustionForRegen = 6.0f;
        float exhaustionForConsumed = 4.0f;
        while (foodLevel >= 18) {
            while (exhaustionLevel > exhaustionForConsumed) {
                exhaustionLevel -= exhaustionForConsumed;
                if (saturationLevel > 0.0f) {
                    saturationLevel = Math.max(saturationLevel - 1.0f, 0.0f);
                    continue;
                }
                --foodLevel;
            }
            if (foodLevel >= 20 && saturationLevel > 0.0f) {
                float limitedSaturationLevel = Math.min(saturationLevel, exhaustionForRegen);
                health += limitedSaturationLevel / exhaustionForRegen;
                exhaustionLevel += limitedSaturationLevel;
                continue;
            }
            if (foodLevel < 18) continue;
            health += 1.0f;
            exhaustionLevel += exhaustionForRegen;
        }
        return health;
    }
}

