/*
 * Decompiled with CFR 0.152.
 */
package com.command_block.www.awesomedungeon;

import com.command_block.www.awesomedungeon.AwesomeDungeon;
import com.command_block.www.awesomedungeon.configuration.Configuration;
import com.command_block.www.awesomedungeon.structures.DefaultJungleTemple;
import com.command_block.www.awesomedungeon.structures.DesertTempleHusk;
import com.command_block.www.awesomedungeon.structures.GiantJungleTree;
import com.command_block.www.awesomedungeon.structures.MushroomAbandonned;
import com.command_block.www.awesomedungeon.structures.OakPalace;
import com.command_block.www.awesomedungeon.structures.SwampBigTemple;
import com.command_block.www.awesomedungeon.structures.TheZTower;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ModStructures {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<Structure<?>> DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"awesomedungeon");
    private static final RegistryObject<Structure<NoFeatureConfig>> GIANT_JUNGLE_TREE = DEFERRED.register(GiantJungleTree.NAME, GiantJungleTree::new);
    private static final RegistryObject<Structure<NoFeatureConfig>> OAK_PALACE = DEFERRED.register(OakPalace.NAME, OakPalace::new);
    private static final RegistryObject<Structure<NoFeatureConfig>> SWAMP_TEMPLE = DEFERRED.register(SwampBigTemple.NAME, SwampBigTemple::new);
    private static final RegistryObject<Structure<NoFeatureConfig>> DESERT_TEMPLE = DEFERRED.register(DesertTempleHusk.NAME, DesertTempleHusk::new);
    private static final RegistryObject<Structure<NoFeatureConfig>> DEFAULT_JUNGLE_TEMPLE = DEFERRED.register(DefaultJungleTemple.NAME, DefaultJungleTemple::new);
    private static final RegistryObject<Structure<NoFeatureConfig>> THE_Z_TOWER = DEFERRED.register(TheZTower.NAME, TheZTower::new);
    private static final RegistryObject<Structure<NoFeatureConfig>> MUSHROOM_ABANDONNED = DEFERRED.register(MushroomAbandonned.NAME, MushroomAbandonned::new);
    private static Method GETCODEC_METHOD;

    ModStructures() {
    }

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand((Structure)GIANT_JUNGLE_TREE.get(), new StructureSeparationSettings(Configuration.get().getNumberOrDefault(AwesomeDungeon.SPACING_STRUCTURE_GIANT_JUNGLE_TREE), Configuration.get().getNumberOrDefault(AwesomeDungeon.SEPARATION_STRUCTURE_GIANT_JUNGLE_TREE), 1234567890), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)GIANT_JUNGLE_TREE.get()), GiantJungleTree.NAME);
        ModStructures.setupMapSpacingAndLand((Structure)OAK_PALACE.get(), new StructureSeparationSettings(Configuration.get().getNumberOrDefault(AwesomeDungeon.SPACING_STRUCTURE_OAK_PALACE), Configuration.get().getNumberOrDefault(AwesomeDungeon.SEPARATION_STRUCTURE_OAK_PALACE), 123456789), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)OAK_PALACE.get()), OakPalace.NAME);
        ModStructures.setupMapSpacingAndLand((Structure)SWAMP_TEMPLE.get(), new StructureSeparationSettings(Configuration.get().getNumberOrDefault(AwesomeDungeon.SPACING_STRUCTURE_SWAMP_TEMPLE), Configuration.get().getNumberOrDefault(AwesomeDungeon.SEPARATION_STRUCTURE_SWAMP_TEMPLE), 12345678), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)SWAMP_TEMPLE.get()), SwampBigTemple.NAME);
        ModStructures.setupMapSpacingAndLand((Structure)DESERT_TEMPLE.get(), new StructureSeparationSettings(Configuration.get().getNumberOrDefault(AwesomeDungeon.SPACING_STRUCTURE_DESERT_TEMPLE_HUSK), Configuration.get().getNumberOrDefault(AwesomeDungeon.SEPARATION_STRUCTURE_DESERT_TEMPLE_HUSK), 1234567), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)DESERT_TEMPLE.get()), DesertTempleHusk.NAME);
        ModStructures.setupMapSpacingAndLand((Structure)DEFAULT_JUNGLE_TEMPLE.get(), new StructureSeparationSettings(Configuration.get().getNumberOrDefault(AwesomeDungeon.SPACING_STRUCTURE_DEFAULT_JUNGLE_TEMPLE), Configuration.get().getNumberOrDefault(AwesomeDungeon.SEPARATION_STRUCTURE_DEFAULT_JUNGLE_TEMPLE), 123456), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)DEFAULT_JUNGLE_TEMPLE.get()), DefaultJungleTemple.NAME);
        ModStructures.setupMapSpacingAndLand((Structure)THE_Z_TOWER.get(), new StructureSeparationSettings(Configuration.get().getNumberOrDefault(AwesomeDungeon.SPACING_STRUCTURE_THE_Z_TOWER), Configuration.get().getNumberOrDefault(AwesomeDungeon.SEPARATION_STRUCTURE_THE_Z_TOWER), 123454596), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)THE_Z_TOWER.get()), TheZTower.NAME);
        ModStructures.setupMapSpacingAndLand((Structure)MUSHROOM_ABANDONNED.get(), new StructureSeparationSettings(Configuration.get().getNumberOrDefault(AwesomeDungeon.SPACING_STRUCTURE_MUSHROOM_ABANDONNED), Configuration.get().getNumberOrDefault(AwesomeDungeon.SEPARATION_STRUCTURE_MUSHROOM_ABANDONNED), 228924156), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)MUSHROOM_ABANDONNED.get()), MushroomAbandonned.NAME);
    }

    public static void biomeModification(BiomeLoadingEvent event) {
        if (event.getName().equals((Object)Biomes.field_76782_w.func_240901_a_())) {
            event.getGeneration().getStructures().add(() -> ((Structure)GIANT_JUNGLE_TREE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            event.getGeneration().getStructures().add(() -> ((Structure)DEFAULT_JUNGLE_TEMPLE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (event.getName().equals((Object)Biomes.field_76769_d.func_240901_a_())) {
            event.getGeneration().getStructures().add(() -> ((Structure)DESERT_TEMPLE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (event.getName().equals((Object)Biomes.field_150599_m.func_240901_a_())) {
            event.getGeneration().getStructures().add(() -> ((Structure)SWAMP_TEMPLE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (event.getName().equals((Object)Biomes.field_76767_f.func_240901_a_()) || event.getName().equals((Object)Biomes.field_76772_c.func_240901_a_())) {
            event.getGeneration().getStructures().add(() -> ((Structure)THE_Z_TOWER.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            event.getGeneration().getStructures().add(() -> ((Structure)MUSHROOM_ABANDONNED.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (event.getName().equals((Object)Biomes.field_76767_f.func_240901_a_()) || event.getName().equals((Object)Biomes.field_76772_c.func_240901_a_()) || event.getName().equals((Object)Biomes.field_76768_g.func_240901_a_()) || event.getName().equals((Object)Biomes.field_76781_i.func_240901_a_())) {
            event.getGeneration().getStructures().add(() -> ((Structure)OAK_PALACE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ModStructures.preAddDimensionalSpacing(serverWorld);
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(GIANT_JUNGLE_TREE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)GIANT_JUNGLE_TREE.get()));
            tempMap.putIfAbsent(OAK_PALACE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)OAK_PALACE.get()));
            tempMap.putIfAbsent(SWAMP_TEMPLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SWAMP_TEMPLE.get()));
            tempMap.putIfAbsent(DESERT_TEMPLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)DESERT_TEMPLE.get()));
            tempMap.putIfAbsent(DEFAULT_JUNGLE_TEMPLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)DEFAULT_JUNGLE_TEMPLE.get()));
            tempMap.putIfAbsent(THE_Z_TOWER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)THE_Z_TOWER.get()));
            tempMap.putIfAbsent(MUSHROOM_ABANDONNED.get(), DimensionStructuresSettings.field_236191_b_.get((Object)MUSHROOM_ABANDONNED.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    private static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    private static void registerConfiguredStructures(Structure<NoFeatureConfig> structure, String identifierConfig) {
        Registry registry = WorldGenRegistries.field_243654_f;
        StructureFeature CONFIGURED_RUN_DOWN_HOUSE = structure.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("awesomedungeon", "configured_" + identifierConfig), (Object)CONFIGURED_RUN_DOWN_HOUSE);
        FlatGenerationSettings.field_202247_j.put(structure, CONFIGURED_RUN_DOWN_HOUSE);
    }

    private static void preAddDimensionalSpacing(ServerWorld serverWorld) {
        try {
            ResourceLocation cgRL;
            if (GETCODEC_METHOD == null) {
                GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
            }
            if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
        }
    }
}

