/*
 * Decompiled with CFR 0.152.
 */
package com.command_block.www.awesomedungeon.structures;

import com.command_block.www.awesomedungeon.AwesomeDungeon;
import com.command_block.www.awesomedungeon.configuration.Configuration;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OakPalace
extends Structure<NoFeatureConfig> {
    public static final String NAME = Configuration.get().getBoolOrDefault(AwesomeDungeon.ENABLED_STRUCTURE_OAK_PALACE) ? "oak_palace" : "disabled_oak_palace";
    private static final ResourceLocation IDENTIFIER = new ResourceLocation("awesomedungeon", Configuration.get().getBoolOrDefault(AwesomeDungeon.ENABLED_STRUCTURE_OAK_PALACE) ? "oak_palace/start_pool" : "disabled_oak_palace/start_pool");

    public OakPalace() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        BlockPos centerOfChunk = new BlockPos((chunkX << 4) + 7, 0, (chunkZ << 4) + 7);
        int landHeight = chunkGenerator.func_222529_a(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
        return topBlock.func_204520_s().func_206888_e();
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            BlockPos blockpos = new BlockPos(x, 0, z);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(IDENTIFIER), 10), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)true);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 1, 0));
            this.field_75075_a.forEach(piece -> --piece.func_74874_b().field_78895_b);
            MutableBoundingBox box = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b();
            Vector3i structureCenter = box.func_215126_f();
            int xOffset = blockpos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = blockpos.func_177952_p() - structureCenter.func_177952_p();
            for (StructurePiece structurePiece : this.field_75075_a) {
                structurePiece.func_181138_a(xOffset, 0, zOffset);
            }
            this.func_202500_a();
            int highestLandPos = chunkGenerator.func_222529_a(box.field_78897_a, box.field_78896_c, Heightmap.Type.WORLD_SURFACE_WG);
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(box.field_78897_a, box.field_78892_f, Heightmap.Type.WORLD_SURFACE_WG));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(box.field_78893_d, box.field_78896_c, Heightmap.Type.WORLD_SURFACE_WG));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(box.field_78893_d, box.field_78892_f, Heightmap.Type.WORLD_SURFACE_WG));
            this.func_214626_a((Random)this.field_214631_d, highestLandPos, highestLandPos);
        }
    }
}

