/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudio.awesomendungeonether;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.jtorleonstudio.awesomendungeonether.SimpleNetherStructure;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ModStructures {
    private static final Logger LOGGER = LogManager.getLogger((String)"awesomedungeonnether");
    public static final DeferredRegister<Structure<?>> DEF = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"awesomedungeonnether");
    public static final String OBSI_PALACE_ID = "nth_absi_palace";
    public static final RegistryObject<Structure<NoFeatureConfig>> OBSI_PALACE = DEF.register("nth_absi_palace", () -> new SimpleNetherStructure(OBSI_PALACE_ID));
    public static final String OBSI_HOUSE_ID = "nth_obsi_house";
    public static final RegistryObject<Structure<NoFeatureConfig>> OBSI_HOUSE = DEF.register("nth_obsi_house", () -> new SimpleNetherStructure(OBSI_HOUSE_ID));
    public static final String CRIM_TREE_ID = "nth_giant_crimson_tree";
    public static final RegistryObject<Structure<NoFeatureConfig>> CRIM_TREE = DEF.register("nth_giant_crimson_tree", () -> new SimpleNetherStructure(CRIM_TREE_ID));
    public static final String SQUARE_ID = "nth_center_square";
    public static final RegistryObject<Structure<NoFeatureConfig>> SQUARE = DEF.register("nth_center_square", () -> new SimpleNetherStructure(SQUARE_ID));
    public static final String ACCUM_ID = "nth_accum_quad";
    public static final RegistryObject<Structure<NoFeatureConfig>> ACCUM = DEF.register("nth_accum_quad", () -> new SimpleNetherStructure(ACCUM_ID));
    public static final String BLAZETOWER_ID = "nth_blaze_tower";
    public static final RegistryObject<Structure<NoFeatureConfig>> BLAZETOWER = DEF.register("nth_blaze_tower", () -> new SimpleNetherStructure(BLAZETOWER_ID));
    private static Method GETCODEC_METHOD;

    ModStructures() {
    }

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand((Structure)OBSI_PALACE.get(), new StructureSeparationSettings(100, 50, 154835856), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)OBSI_PALACE.get()), OBSI_PALACE_ID);
        ModStructures.setupMapSpacingAndLand((Structure)OBSI_HOUSE.get(), new StructureSeparationSettings(100, 50, 254835856), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)OBSI_HOUSE.get()), OBSI_HOUSE_ID);
        ModStructures.setupMapSpacingAndLand((Structure)CRIM_TREE.get(), new StructureSeparationSettings(100, 50, 354835856), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)CRIM_TREE.get()), CRIM_TREE_ID);
        ModStructures.setupMapSpacingAndLand((Structure)SQUARE.get(), new StructureSeparationSettings(100, 50, 454835856), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)SQUARE.get()), SQUARE_ID);
        ModStructures.setupMapSpacingAndLand((Structure)ACCUM.get(), new StructureSeparationSettings(100, 50, 554835856), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)ACCUM.get()), ACCUM_ID);
        ModStructures.setupMapSpacingAndLand((Structure)BLAZETOWER.get(), new StructureSeparationSettings(100, 50, 654835856), true);
        ModStructures.registerConfiguredStructures((Structure<NoFeatureConfig>)((Structure)BLAZETOWER.get()), BLAZETOWER_ID);
    }

    public static void biomeModification(BiomeLoadingEvent e) {
        if (e.getName().equals((Object)Biomes.field_235252_ay_.func_240901_a_())) {
            e.getGeneration().getStructures().add(() -> ((Structure)OBSI_PALACE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (e.getName().equals((Object)Biomes.field_235250_aA_.func_240901_a_())) {
            e.getGeneration().getStructures().add(() -> ((Structure)OBSI_HOUSE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (e.getName().equals((Object)Biomes.field_235253_az_.func_240901_a_())) {
            e.getGeneration().getStructures().add(() -> ((Structure)CRIM_TREE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (e.getName().equals((Object)Biomes.field_235254_j_.func_240901_a_())) {
            e.getGeneration().getStructures().add(() -> ((Structure)SQUARE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            e.getGeneration().getStructures().add(() -> ((Structure)ACCUM.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            e.getGeneration().getStructures().add(() -> ((Structure)BLAZETOWER.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ModStructures.preAddDimensionalSpacing(serverWorld);
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tmpMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tmpMap.putIfAbsent(OBSI_PALACE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)OBSI_PALACE.get()));
            tmpMap.putIfAbsent(OBSI_HOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)OBSI_HOUSE.get()));
            tmpMap.putIfAbsent(CRIM_TREE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)CRIM_TREE.get()));
            tmpMap.putIfAbsent(SQUARE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SQUARE.get()));
            tmpMap.putIfAbsent(ACCUM.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SQUARE.get()));
            tmpMap.putIfAbsent(BLAZETOWER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BLAZETOWER.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tmpMap;
        }
    }

    private static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    private static void registerConfiguredStructures(Structure<NoFeatureConfig> structure, String identifierConfig) {
        Registry registry = WorldGenRegistries.field_243654_f;
        StructureFeature CONFIGURED_RUN_DOWN_HOUSE = structure.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("awesomedungeonnether", "configured_" + identifierConfig), (Object)CONFIGURED_RUN_DOWN_HOUSE);
        FlatGenerationSettings.field_202247_j.put(structure, CONFIGURED_RUN_DOWN_HOUSE);
    }

    private static void preAddDimensionalSpacing(ServerWorld serverWorld) {
        try {
            ResourceLocation cgRL;
            if (GETCODEC_METHOD == null) {
                GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
            }
            if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
        }
    }
}

