/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudio.awesomendungeonether;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SimpleNetherStructure
extends Structure<NoFeatureConfig> {
    private final String identifier;

    public SimpleNetherStructure(String IDENTIFIER) {
        super(NoFeatureConfig.field_236558_a_);
        this.identifier = IDENTIFIER;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        return !SimpleNetherStructure.getPotentielPosition(chunkGenerator, chunkPos).isEmpty();
    }

    private static List<BlockPos.Mutable> getPotentielPosition(ChunkGenerator chunkGenerator, ChunkPos chunkPos) {
        BlockPos centerOfChunk = new BlockPos(chunkPos.field_77276_a * 16, 0, chunkPos.field_77275_b * 16);
        int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG) - 50;
        BlockPos.Mutable bpm = new BlockPos.Mutable(centerOfChunk.func_177958_n(), 0, centerOfChunk.func_177952_p());
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        ArrayList<BlockPos.Mutable> data = new ArrayList<BlockPos.Mutable>();
        for (int i = 0; i < landHeight; ++i) {
            BlockState beforeMoveState = columnOfBlocks.func_180495_p((BlockPos)bpm);
            boolean beforeMoveIsGround = !beforeMoveState.func_196958_f() && beforeMoveState.func_204520_s().func_206888_e();
            bpm.func_189536_c(Direction.UP);
            if (!beforeMoveIsGround || !columnOfBlocks.func_180495_p((BlockPos)bpm).func_196958_f()) continue;
            data.add(bpm.func_239590_i_());
        }
        return data;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos blockpos = new BlockPos(x, 0, z);
            List data = SimpleNetherStructure.getPotentielPosition(chunkGenerator, new ChunkPos(chunkX, chunkZ));
            Random rand = new Random();
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("awesomedungeonnether", ((SimpleNetherStructure)this.func_214627_k()).identifier + "/start_pool")), 10), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)((BlockPos)data.get(rand.nextInt(data.size()))), (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 2, 0));
            this.field_75075_a.forEach(piece -> --piece.func_74874_b().field_78895_b);
            MutableBoundingBox box = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b();
            Vector3i structureCenter = box.func_215126_f();
            int xOffset = blockpos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = blockpos.func_177952_p() - structureCenter.func_177952_p();
            for (StructurePiece structurePiece : this.field_75075_a) {
                structurePiece.func_181138_a(xOffset, 0, zOffset);
            }
            this.func_202500_a();
        }
    }
}

