/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.net;

import java.util.function.Supplier;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRotate {
    private final int id;
    private final boolean counterClockwise;

    public MessageRotate(int id, boolean counterClockwise) {
        this.id = id;
        this.counterClockwise = counterClockwise;
    }

    public static MessageRotate decode(PacketBuffer buf) {
        byte id = buf.readByte();
        boolean counterClockwise = buf.readBoolean();
        return new MessageRotate(id, counterClockwise);
    }

    public static void encode(MessageRotate message, PacketBuffer buf) {
        buf.writeByte(message.id);
        buf.writeBoolean(message.counterClockwise);
    }

    public static void handle(MessageRotate message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            TweakProvider<Container> tweakProvider;
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            Container container = player.field_71070_bA;
            if (container != null && (tweakProvider = CraftingTweaksProviderManager.getProvider(container)) != null) {
                tweakProvider.rotateGrid((PlayerEntity)player, container, message.id, message.counterClockwise);
            }
        });
        context.setPacketHandled(true);
    }
}

