/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.hardcorerevival.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.IHardcoreRevival;
import net.blay09.mods.hardcorerevival.network.MessageRevivalProgress;
import net.blay09.mods.hardcorerevival.network.MessageRevivalSuccess;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.PacketDistributor;

public class RescueHandler {
    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            RescueHandler.abortRescue((PlayerEntity)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        RescueHandler.abortRescue(event.getPlayer());
    }

    public static void startRescue(PlayerEntity player, PlayerEntity target) {
        LazyOptional revival = player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            it.setRescueTarget(target);
            it.setRescueTime(0);
            NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageRevivalProgress(target.func_145782_y(), 0.1f));
        });
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            LazyOptional revival = event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
            revival.ifPresent(it -> {
                if (it.getRescueTarget() != null) {
                    int deathTime = it.getRescueTarget().getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null).map(IHardcoreRevival::getDeathTime).orElse(0);
                    if (it.getRescueTarget().field_70128_L || deathTime >= (Integer)HardcoreRevivalConfig.SERVER.maxDeathTicks.get()) {
                        RescueHandler.abortRescue(event.player);
                    } else {
                        float dist = event.player.func_70032_d((Entity)it.getRescueTarget());
                        if ((double)dist > (Double)HardcoreRevivalConfig.SERVER.maxRescueDist.get()) {
                            RescueHandler.abortRescue(event.player);
                        } else {
                            int rescueTime = it.getRescueTime() + 1;
                            it.setRescueTime(rescueTime);
                            int step = (Integer)HardcoreRevivalConfig.SERVER.rescueTime.get() / 4;
                            if (rescueTime >= (Integer)HardcoreRevivalConfig.SERVER.rescueTime.get()) {
                                RescueHandler.finishRescue(event.player);
                            } else if (rescueTime % step == 0) {
                                NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.player), (Object)new MessageRevivalProgress(it.getRescueTarget().func_145782_y(), (float)rescueTime / (float)((Integer)HardcoreRevivalConfig.SERVER.rescueTime.get()).intValue()));
                            }
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity original = event.getOriginal();
        LazyOptional revival = original.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            if (it.getDeathTime() > 0) {
                event.getPlayer().func_70012_b(original.func_226277_ct_(), original.func_226278_cu_(), original.func_226281_cx_(), 0.0f, 0.0f);
            }
        });
    }

    public static void finishRescue(PlayerEntity player) {
        LazyOptional revival = player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            MinecraftServer server;
            PlayerEntity target = it.getRescueTarget();
            if (target != null && (server = target.func_184102_h()) != null) {
                if (((Boolean)HardcoreRevivalConfig.SERVER.glowOnDeath.get()).booleanValue()) {
                    target.func_184195_f(false);
                }
                target.func_70606_j((float)((Integer)HardcoreRevivalConfig.SERVER.rescueRespawnHealth.get()).intValue());
                target.func_71024_bL().func_75114_a(((Integer)HardcoreRevivalConfig.SERVER.rescueRespawnFoodLevel.get()).intValue());
                target.func_195064_c(new EffectInstance(Effects.field_76438_s, 600));
                target.func_195064_c(new EffectInstance(Effects.field_76437_t, 1200));
                target.func_70066_B();
                target.field_70725_aQ = -1;
                target.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null).ifPresent(ot -> ot.setDeathTime(0));
                NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageRevivalProgress(it.getRescueTarget().func_145782_y(), -1.0f));
                NetworkHandler.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)new MessageRevivalSuccess(target.func_145782_y()));
                it.setRescueTarget(null);
            }
        });
    }

    public static void abortRescue(PlayerEntity player) {
        LazyOptional revival = player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            if (it.getRescueTarget() != null) {
                it.setRescueTime(0);
                it.setRescueTarget(null);
                NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageRevivalProgress(-1, -1.0f));
            }
        });
    }
}

