/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.util.text.Color;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="healthoverlay")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HealthOverlay {
    public static final Logger LOGGER = LogManager.getLogger((String)"HealthOverlay");
    public static final String MOD_ID = "healthoverlay";
    private static final ForgeConfigSpec CONFIG_SPEC;
    private static final Runnable run;
    public static Color[] healthColors;
    public static Color[] poisonColors;
    public static Color[] witherColors;
    public static Color[] absorptionColors;

    public HealthOverlay() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CONFIG_SPEC, "healthoverlay.toml");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        HealthOverlay.loadConfig(FMLPaths.CONFIGDIR.get().resolve("healthoverlay.toml"));
    }

    private static void loadConfig(Path path) {
        LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        CONFIG_SPEC.setConfig((CommentedConfig)configData);
    }

    private static Color[] getColors(List<? extends String> stringValues) {
        Color[] colorValues = new Color[10];
        if (stringValues != null && !stringValues.isEmpty()) {
            if (colorValues.length != stringValues.size() - 1) {
                colorValues = new Color[stringValues.size()];
            }
            for (int i = 0; i < stringValues.size(); ++i) {
                colorValues[i] = Color.func_240743_a_((int)Integer.decode(stringValues.get(i)));
            }
        }
        return colorValues;
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.ModConfigEvent event) {
        if (!event.getConfig().getModId().equals(MOD_ID)) {
            return;
        }
        run.run();
        LOGGER.debug("Loaded {} config file {}", (Object)MOD_ID, (Object)event.getConfig().getFileName());
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("All the values are written as a Hexadecimal number in the '#RRGGBB' format").push("Heart colors");
        ForgeConfigSpec.ConfigValue health = builder.comment("Colors for every 10 hearts (not counting the default red)").defineList("heartColors", (List)Lists.newArrayList((Object[])new String[]{Color.func_240743_a_((int)15756820).toString(), Color.func_240743_a_((int)16112675).toString(), Color.func_240743_a_((int)2996520).toString(), Color.func_240743_a_((int)2011070).toString(), Color.func_240743_a_((int)7554785).toString(), Color.func_240743_a_((int)16416235).toString(), Color.func_240743_a_((int)15415130).toString(), Color.func_240743_a_((int)16745080).toString(), Color.func_240743_a_((int)0xAAFFFA).toString(), Color.func_240743_a_((int)0xEBEBFF).toString()}), o -> o != null && String.class.isAssignableFrom(o.getClass()));
        ForgeConfigSpec.ConfigValue poison = builder.comment("Two alternating colors when poisoned").defineList("poisonColors", (List)Lists.newArrayList((Object[])new String[]{Color.func_240743_a_((int)7576320).toString(), Color.func_240743_a_((int)9882880).toString()}), o -> o != null && String.class.isAssignableFrom(o.getClass()));
        ForgeConfigSpec.ConfigValue wither = builder.comment("Two alternating colors when withered").defineList("witherColors", (List)Lists.newArrayList((Object[])new String[]{Color.func_240743_a_((int)986895).toString(), Color.func_240743_a_((int)0x2D2D2D).toString()}), o -> o != null && String.class.isAssignableFrom(o.getClass()));
        ForgeConfigSpec.ConfigValue absorption = builder.comment("Colors for every 10 absorption hearts (not counting the default yellow)").defineList("absorptionColors", (List)Lists.newArrayList((Object[])new String[]{Color.func_240743_a_((int)14809755).toString(), Color.func_240743_a_((int)0xA0FFAF).toString(), Color.func_240743_a_((int)0xAAFFFA).toString(), Color.func_240743_a_((int)11193855).toString(), Color.func_240743_a_((int)14136575).toString(), Color.func_240743_a_((int)0xFAA5FF).toString(), Color.func_240743_a_((int)0xFFB4B4).toString(), Color.func_240743_a_((int)16755325).toString(), Color.func_240743_a_((int)14151935).toString(), Color.func_240743_a_((int)15466490).toString()}), o -> o != null && String.class.isAssignableFrom(o.getClass()));
        builder.pop();
        run = () -> {
            healthColors = HealthOverlay.getColors((List)health.get());
            poisonColors = HealthOverlay.getColors((List)poison.get());
            witherColors = HealthOverlay.getColors((List)wither.get());
            absorptionColors = HealthOverlay.getColors((List)absorption.get());
        };
        CONFIG_SPEC = builder.build();
    }
}

