/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import terrails.healthoverlay.HealthOverlay;
import terrails.healthoverlay.RenderUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="healthoverlay")
public class HealthRenderer {
    private static final ResourceLocation HEALTH_ICONS_LOCATION = new ResourceLocation("healthoverlay:textures/health.png");
    private static final ResourceLocation ABSORPTION_ICONS_LOCATION = new ResourceLocation("healthoverlay:textures/absorption.png");
    private static final ResourceLocation HALF_HEART_ICONS_LOCATION = new ResourceLocation("healthoverlay:textures/half_heart.png");
    private static final Minecraft client = Minecraft.func_71410_x();
    private static final Random random = new Random();
    private static int prevHealth;
    private static int health;
    private static long prevSystemTime;
    private static long healthTicks;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void render(RenderGameOverlayEvent.Pre event) {
        MatrixStack matrixStack = event.getMatrixStack();
        Entity renderEntity = client.func_175606_aa();
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH || !(renderEntity instanceof PlayerEntity) || event.isCanceled() || HealthOverlay.healthColors.length == 0 || HealthOverlay.absorptionColors.length == 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)renderEntity;
        int ticks = HealthRenderer.client.field_71456_v.func_73834_c();
        int currentHealth = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean highlight = healthTicks > (long)ticks && (healthTicks - (long)ticks) / 3L % 2L == 1L;
        long systemTime = Util.func_211177_b();
        if (currentHealth < health && player.field_70172_ad > 0) {
            prevSystemTime = systemTime;
            healthTicks = ticks + 20;
        } else if (currentHealth > health && player.field_70172_ad > 0) {
            prevSystemTime = systemTime;
            healthTicks = ticks + 10;
        }
        if (systemTime - prevSystemTime > 1000L) {
            health = currentHealth;
            prevHealth = currentHealth;
            prevSystemTime = systemTime;
        }
        health = currentHealth;
        int previousHealth = prevHealth;
        random.setSeed(ticks * 312871);
        int xPos = client.func_228018_at_().func_198107_o() / 2 - 91;
        int yPos = client.func_228018_at_().func_198087_p() - 39;
        float maxHealth = player.func_110138_aP();
        int absorption = MathHelper.func_76123_f((float)player.func_110139_bj());
        currentHealth = Math.min(currentHealth, 20);
        previousHealth = Math.min(previousHealth, 20);
        maxHealth = Math.min(maxHealth, 20.0f);
        int absorptionCount = absorption = Math.min(absorption, 20);
        int rowHeight = 10;
        int regenHealth = -1;
        ForgeIngameGui.left_height += rowHeight + (absorption > 0 ? 10 : 0);
        if (player.func_70644_a(Effects.field_76428_l)) {
            regenHealth = ticks % MathHelper.func_76123_f((float)(maxHealth + 5.0f));
        }
        int effectOffset = 16;
        if (player.func_70644_a(Effects.field_76436_u)) {
            effectOffset += 36;
        } else if (player.func_70644_a(Effects.field_82731_v)) {
            effectOffset += 72;
        }
        int hardcoreOffset = 0;
        if (player.field_70170_p.func_72912_H().func_76093_s()) {
            hardcoreOffset = 5;
        }
        for (int i = MathHelper.func_76123_f((float)((maxHealth + (float)absorption) / 2.0f)) - 1; i >= 0; --i) {
            int value = i * 2 + 1;
            int x = xPos + i % 10 * 8;
            int y = yPos;
            if (currentHealth <= 4) {
                y += random.nextInt(2);
            }
            if (absorptionCount > 0) {
                x = xPos + (MathHelper.func_76123_f((float)((float)absorptionCount / 2.0f)) - 1) % 10 * 8;
                y = yPos - 10;
            }
            if (absorptionCount <= 0 && i == regenHealth) {
                y -= 2;
            }
            if (value % 2 == 1 && (float)value == maxHealth || absorptionCount == absorption && absorption % 2 == 1) {
                client.func_110434_K().func_110577_a(HALF_HEART_ICONS_LOCATION);
                HealthRenderer.drawTexture(matrixStack, x, y, (highlight ? 1 : 0) * 9, 0);
                client.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            } else {
                HealthRenderer.drawTexture(matrixStack, x, y, 16 + (highlight ? 1 : 0) * 9, 9 * hardcoreOffset);
            }
            if (highlight) {
                if (value < previousHealth) {
                    HealthRenderer.drawTexture(matrixStack, x, y, effectOffset + 54, 9 * hardcoreOffset);
                }
                if (value == previousHealth) {
                    HealthRenderer.drawTexture(matrixStack, x, y, effectOffset + 63, 9 * hardcoreOffset);
                }
            }
            if (absorptionCount > 0) {
                if (absorptionCount == absorption && absorption % 2 == 1) {
                    HealthRenderer.drawTexture(matrixStack, x, y, effectOffset + 153, 9 * hardcoreOffset);
                    --absorptionCount;
                    continue;
                }
                HealthRenderer.drawTexture(matrixStack, x, y, effectOffset + 144, 9 * hardcoreOffset);
                absorptionCount -= 2;
                continue;
            }
            if (value < currentHealth) {
                HealthRenderer.drawTexture(matrixStack, x, y, effectOffset + 36, 9 * hardcoreOffset);
            }
            if (value != currentHealth) continue;
            HealthRenderer.drawTexture(matrixStack, x, y, effectOffset + 45, 9 * hardcoreOffset);
        }
        HealthRenderer.renderHearts(matrixStack, player, xPos, yPos, regenHealth, false);
        HealthRenderer.renderHearts(matrixStack, player, xPos, yPos - rowHeight, regenHealth, true);
        event.setCanceled(true);
    }

    private static void renderHearts(MatrixStack matrixStack, PlayerEntity player, int xPosition, int yPosition, int regenHealth, boolean absorption) {
        if (absorption && (player.func_70644_a(Effects.field_76436_u) || player.func_70644_a(Effects.field_82731_v))) {
            return;
        }
        int yTex = player.field_70170_p.func_72912_H().func_76093_s() ? (absorption ? 18 : 45) : 0;
        int xTex = 0;
        int currentValue = MathHelper.func_76123_f((float)(absorption ? player.func_110139_bj() : player.func_110143_aJ())) - 20;
        if (currentValue <= 0) {
            return;
        }
        GlStateManager.func_227740_m_();
        client.func_110434_K().func_110577_a(absorption ? ABSORPTION_ICONS_LOCATION : HEALTH_ICONS_LOCATION);
        int prevType = 0;
        for (int i = 0; i < MathHelper.func_76123_f((float)((float)currentValue / 2.0f)); ++i) {
            int value = i * 2 + 1;
            int regenOffset = !absorption && i - 10 * (i / 10) == regenHealth ? -2 : 0;
            int typeOffset = value / 20 % (absorption ? HealthOverlay.absorptionColors.length : HealthOverlay.healthColors.length);
            Color heartColor = (absorption ? HealthOverlay.absorptionColors : HealthOverlay.healthColors)[typeOffset];
            if (typeOffset > prevType + 1 || typeOffset < prevType - 1) {
                prevType = typeOffset;
            }
            int yPos = yPosition + regenOffset;
            int xPos = xPosition + i % 10 * 8;
            if (player.func_70644_a(Effects.field_76436_u)) {
                xTex = 18;
                heartColor = prevType != typeOffset ? HealthOverlay.poisonColors[0] : HealthOverlay.poisonColors[1];
            } else if (player.func_70644_a(Effects.field_82731_v)) {
                xTex = 36;
                Color color = heartColor = prevType != typeOffset ? HealthOverlay.witherColors[0] : HealthOverlay.witherColors[1];
            }
            if (value < currentValue) {
                HealthRenderer.drawTexture(matrixStack, xPos, yPos, xTex, yTex, heartColor);
                if (player.func_70644_a(Effects.field_82731_v)) {
                    HealthRenderer.drawTexture(matrixStack, xPos, yPos, xTex, yTex + (yTex == 45 ? 27 : 18), 255);
                } else {
                    HealthRenderer.drawTexture(matrixStack, xPos, yPos, xTex, yTex + 9, 56);
                }
                if (yTex == 45 || yTex == 18) {
                    HealthRenderer.drawTexture(matrixStack, xPos, yPos, xTex, yTex + (absorption ? 9 : 18), 178);
                    continue;
                }
                HealthRenderer.drawTexture(matrixStack, xPos, yPos, absorption ? 36 : 54, yTex, 255);
                continue;
            }
            if (value != currentValue) continue;
            HealthRenderer.drawTexture(matrixStack, xPos, yPos, xTex + 9, yTex, heartColor);
            if (player.func_70644_a(Effects.field_82731_v)) {
                HealthRenderer.drawTexture(matrixStack, xPos, yPos, xTex + 9, yTex + (yTex == 45 ? 27 : 18), 255);
            } else {
                HealthRenderer.drawTexture(matrixStack, xPos, yPos, xTex + 9, yTex + 9, 56);
            }
            if (yTex == 45 || yTex == 18) {
                HealthRenderer.drawTexture(matrixStack, xPos, yPos, xTex, yTex + (absorption ? 9 : 18), 178);
                continue;
            }
            HealthRenderer.drawTexture(matrixStack, xPos, yPos, (absorption ? 36 : 54) + 9, yTex, 255);
        }
        GlStateManager.func_227737_l_();
        client.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }

    private static void drawTexture(MatrixStack matrices, int x, int y, int u, int v) {
        HealthRenderer.drawTexture(matrices, x, y, u, v, 0, 0, 0, 0);
    }

    private static void drawTexture(MatrixStack matrices, int x, int y, int u, int v, int alpha) {
        HealthRenderer.drawTexture(matrices, x, y, u, v, 255, 255, 255, alpha);
    }

    private static void drawTexture(MatrixStack matrices, int x, int y, int u, int v, Color color) {
        int rgb = color.func_240742_a_();
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        HealthRenderer.drawTexture(matrices, x, y, u, v, r, g, b, 255);
    }

    private static void drawTexture(MatrixStack matrices, int x, int y, int u, int v, int red, int green, int blue, int alpha) {
        RenderUtils.drawColoredTexturedQuad(matrices.func_227866_c_().func_227870_a_(), x, x + 9, y, y + 9, HealthRenderer.client.field_71456_v.func_230927_p_(), ((float)u + 0.0f) / 256.0f, ((float)u + 9.0f) / 256.0f, ((float)v + 0.0f) / 256.0f, ((float)v + 9.0f) / 256.0f, red, green, blue, alpha);
    }
}

