/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.block.base;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class AbstractPenguinBlock
extends Block {
    protected boolean hasInventory = false;

    public AbstractPenguinBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return this.hasInventory;
    }

    protected void setHasInventory() {
        this.hasInventory = true;
    }

    protected int getInsertAmount(IItemHandler handler, ItemStack held) {
        return held.func_190916_E();
    }

    protected ActionResultType insert(PlayerEntity player, Hand hand, IItemHandler handler) {
        ItemStack held = player.func_184586_b(hand).func_77946_l();
        held.func_190920_e(this.getInsertAmount(handler, held));
        ItemStack ret = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)held, (boolean)false);
        if (ret.func_190916_E() != held.func_190916_E() || ret.func_190926_b()) {
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_190918_g(held.func_190916_E() - ret.func_190916_E());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected int getExtractAmount(IItemHandler handler, int slot) {
        return 1;
    }

    protected ActionResultType extract(PlayerEntity player, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extracted;
            int extract = this.getExtractAmount(handler, i);
            if (extract <= 0 || (extracted = handler.extractItem(i, extract, false)).func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)extracted);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult blockRayTraceResult) {
        if (!this.hasInventory) {
            return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity == null || player.func_225608_bj_()) {
            return ActionResultType.FAIL;
        }
        LazyOptional optional = tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, blockRayTraceResult.func_216354_b());
        if (optional.isPresent()) {
            IItemHandler handler = (IItemHandler)optional.resolve().get();
            return !player.func_184586_b(hand).func_190926_b() && this.insert(player, hand, handler) == ActionResultType.SUCCESS ? ActionResultType.SUCCESS : this.extract(player, handler);
        }
        return ActionResultType.PASS;
    }

    protected void onRemoved(IItemHandler handler, World world, BlockPos pos) {
        NonNullList list = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack inSlot = handler.getStackInSlot(i);
            if (inSlot.func_190926_b()) continue;
            list.set(i, (Object)inSlot);
        }
        InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)list);
    }

    public void func_196243_a(BlockState oldState, @Nonnull World world, @Nonnull BlockPos pos, BlockState newState, boolean bool) {
        if (!this.hasInventory) {
            super.func_196243_a(oldState, world, pos, newState, bool);
            return;
        }
        if (!oldState.func_203425_a(newState.func_177230_c())) {
            LazyOptional optional;
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity != null && (optional = tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
                this.onRemoved((IItemHandler)optional.resolve().get(), world, pos);
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(oldState, world, pos, newState, bool);
        }
    }
}

