/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.client.gui.book;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.client.gui.AbstractContainerScreen;
import uk.joshiejack.penguinlib.client.gui.book.page.AbstractPage;
import uk.joshiejack.penguinlib.client.gui.book.tab.Tab;
import uk.joshiejack.penguinlib.inventory.AbstractBookContainer;

@OnlyIn(value=Dist.CLIENT)
public class Book
extends AbstractContainerScreen<AbstractBookContainer> {
    private static final Object2ObjectMap<String, Book> BOOK_INSTANCES = new Object2ObjectOpenHashMap();
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final ResourceLocation backgroundL;
    private final ResourceLocation backgroundR;
    private int centre;
    private int bgLeftOffset;
    private Tab defaultTab = Tab.EMPTY;
    private Tab tab;
    public int fontColor1 = 8746836;
    public int fontColor2 = 0x404040;
    public int lineColor1 = -5200765;
    public int lineColor2 = -6517661;

    public Book(String modid, AbstractBookContainer container, PlayerInventory inv, ITextComponent name) {
        super(container, inv, name, null, 360, 230);
        this.backgroundL = new ResourceLocation(modid, "textures/gui/book_left.png");
        this.backgroundR = new ResourceLocation(modid, "textures/gui/book_right.png");
    }

    public static Book getInstance(String modid, AbstractBookContainer container, PlayerInventory inv, ITextComponent name, Consumer<Book> consumer) {
        if (!BOOK_INSTANCES.containsKey((Object)modid)) {
            Book screen = new Book(modid, container, inv, name);
            consumer.accept(screen);
            BOOK_INSTANCES.put((Object)modid, (Object)screen);
        }
        return (Book)((Object)BOOK_INSTANCES.get((Object)modid));
    }

    @Nonnull
    public <T extends Widget> T func_230480_a_(@Nonnull T button) {
        return (T)super.func_230480_a_(button);
    }

    @Nonnull
    public <T extends IGuiEventListener> T func_230481_d_(@Nonnull T widget) {
        return (T)super.func_230481_d_(widget);
    }

    public void setTab(Tab tab) {
        this.tab = tab;
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    public void bindLeftTexture() {
        this.field_230706_i_.func_110434_K().func_110577_a(this.backgroundL);
    }

    public Tab withTab(Tab tab) {
        if (!this.tabs.contains(tab)) {
            this.tabs.add(tab);
        }
        if (this.defaultTab == Tab.EMPTY) {
            this.defaultTab = tab;
        }
        return tab;
    }

    public Tab getTab() {
        return this.tab;
    }

    public Minecraft minecraft() {
        return this.field_230706_i_;
    }

    public boolean isSelected(AbstractPage page) {
        return this.tab.getPage() == page;
    }

    public boolean isSelected(Tab tab) {
        return this.tab == tab;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2 + 10;
        this.centre = this.field_147003_i + this.field_146999_f / 2;
        this.bgLeftOffset = this.centre - 154;
        this.field_238742_p_ = this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2;
        this.field_238743_q_ = -10;
        if (this.tab == null) {
            this.tab = this.defaultTab;
        }
        this.tab.getPage().initLeft(this, this.bgLeftOffset, 15 + this.field_147009_r);
        this.tab.getPage().initRight(this, this.centre, 15 + this.field_147009_r);
        this.tab.addTabs(this, this.centre + 154, 15 + this.field_147009_r);
        if (this.tabs.size() > 1) {
            int y = 0;
            for (Tab tab : this.tabs) {
                this.func_230480_a_(tab.create(this, this.centre - 180, 15 + this.field_147009_r + y++ * 36));
            }
        }
    }

    @Override
    protected void func_230450_a_(@Nonnull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_230446_a_(matrix);
        this.field_230706_i_.func_110434_K().func_110577_a(this.backgroundL);
        this.func_238474_b_(matrix, this.bgLeftOffset, this.field_147009_r, 102, 0, 154, 202);
        this.field_230706_i_.func_110434_K().func_110577_a(this.backgroundR);
        this.func_238474_b_(matrix, this.centre, this.field_147009_r, 0, 0, 154, 202);
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrix, int x, int y) {
        this.field_230712_o_.func_243246_a(matrix, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0xFFFFFF);
    }
}

