/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.client.gui.book.page;

import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.client.gui.book.Book;
import uk.joshiejack.penguinlib.client.gui.book.tab.Tab;
import uk.joshiejack.penguinlib.client.gui.book.widget.TabButton;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractPage {
    public static final ITextComponent EMPTY_STRING = new StringTextComponent("");
    public static final AbstractPage EMPTY = new Basic(EMPTY_STRING);
    private final ITextComponent name;

    public AbstractPage(ITextComponent name) {
        this.name = name;
    }

    public AbstractButton createTab(Book book, Tab tab, int x, int y) {
        return new TabButton.Right(book, this.getIcon(), x, y, this.name, btn -> {
            tab.setPage(this);
            book.func_231158_b_(book.minecraft(), book.field_230708_k_, book.field_230709_l_);
        }, this.createTooltip(book, this.name), book.isSelected(this));
    }

    protected abstract Icon getIcon();

    public abstract void initLeft(Book var1, int var2, int var3);

    public abstract void initRight(Book var1, int var2, int var3);

    protected Button.ITooltip createTooltip(Book book, ITextComponent tooltip) {
        return (btn, mtx, mX, mY) -> book.func_238654_b_(mtx, book.minecraft().field_71466_p.func_238425_b_((ITextProperties)tooltip, Math.max(book.field_230708_k_ / 2 - 43, 170)), mX, mY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Basic
    extends AbstractPage {
        public Basic(ITextComponent name) {
            super(name);
        }

        @Override
        protected Icon getIcon() {
            return ItemIcon.EMPTY;
        }

        @Override
        public void initLeft(Book book, int left, int top) {
        }

        @Override
        public void initRight(Book book, int left, int top) {
        }
    }
}

