/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.client.helpers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public abstract class BakedModelHelper {
    public static void buildCube(Direction side, TextureAtlasSprite sprite, List<BakedQuad> quads) {
        switch (side) {
            case DOWN: {
                quads.add(BakedModelHelper.buildQuad(Direction.DOWN, sprite, 0.0f, 0.0f, 1.0f, sprite.func_94209_e(), sprite.func_94206_g(), 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 0.0f, 1.0f, sprite.func_94212_f(), sprite.func_94206_g()));
                break;
            }
            case UP: {
                quads.add(BakedModelHelper.buildQuad(Direction.UP, sprite, 0.0f, 1.0f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), 0.0f, 1.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g()));
                break;
            }
            case NORTH: {
                quads.add(BakedModelHelper.buildQuad(Direction.NORTH, sprite, 1.0f, 1.0f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), 0.0f, 1.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g()));
                break;
            }
            case SOUTH: {
                quads.add(BakedModelHelper.buildQuad(Direction.SOUTH, sprite, 0.0f, 1.0f, 1.0f, sprite.func_94209_e(), sprite.func_94206_g(), 0.0f, 0.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 1.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, sprite.func_94212_f(), sprite.func_94206_g()));
                break;
            }
            case WEST: {
                quads.add(BakedModelHelper.buildQuad(Direction.WEST, sprite, 0.0f, 1.0f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 0.0f, 1.0f, sprite.func_94212_f(), sprite.func_94210_h(), 0.0f, 1.0f, 1.0f, sprite.func_94212_f(), sprite.func_94206_g()));
                break;
            }
            case EAST: {
                quads.add(BakedModelHelper.buildQuad(Direction.EAST, sprite, 1.0f, 1.0f, 1.0f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 0.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g()));
            }
        }
    }

    public static BakedQuad retexture(BakedQuad original, TextureAtlasSprite sprite) {
        int positionOffset;
        int[] vertexData = original.func_178209_a();
        int[] newVertexData = new int[vertexData.length];
        System.arraycopy(vertexData, 0, newVertexData, 0, newVertexData.length);
        int vertexSizeInts = DefaultVertexFormats.field_176600_a.func_181719_f();
        Optional<VertexFormatElement> positionElement = DefaultVertexFormats.field_176600_a.func_227894_c_().stream().filter(e -> VertexFormatElement.Usage.UV.equals((Object)e.func_177375_c())).findFirst();
        for (int i = positionOffset = positionElement.get().func_177369_e(); i < vertexData.length; i += vertexSizeInts) {
            newVertexData[i + 4] = Float.floatToRawIntBits(sprite.func_94214_a((double)BakedModelHelper.unU(original.func_187508_a(), Float.intBitsToFloat(vertexData[i + 4]))));
            newVertexData[i + 5] = Float.floatToRawIntBits(sprite.func_94207_b((double)BakedModelHelper.unV(original.func_187508_a(), Float.intBitsToFloat(vertexData[i + 5]))));
        }
        return new BakedQuad(newVertexData, 0, original.func_178210_d(), sprite, false);
    }

    private static float unU(TextureAtlasSprite sprite, float u) {
        return (u - sprite.func_94209_e()) / (sprite.func_94212_f() - sprite.func_94209_e()) * 16.0f;
    }

    private static float unV(TextureAtlasSprite sprite, float v) {
        return (v - sprite.func_94206_g()) / (sprite.func_94210_h() - sprite.func_94206_g()) * 16.0f;
    }

    public static BakedQuad buildQuad(Direction side, TextureAtlasSprite sprite, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setApplyDiffuseLighting(true);
        builder.setContractUVs(true);
        builder.setQuadOrientation(side);
        BakedModelHelper.putVertex((IVertexConsumer)builder, side, x0, y0, z0, u0, v0);
        BakedModelHelper.putVertex((IVertexConsumer)builder, side, x1, y1, z1, u1, v1);
        BakedModelHelper.putVertex((IVertexConsumer)builder, side, x2, y2, z2, u2, v2);
        BakedModelHelper.putVertex((IVertexConsumer)builder, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, Direction side, float x, float y, float z, float u, float v) {
        ImmutableList elements = consumer.getVertexFormat().func_227894_c_();
        block6: for (int e = 0; e <= elements.size() - 1; ++e) {
            VertexFormatElement element = (VertexFormatElement)elements.get(e);
            switch (element.func_177375_c()) {
                case POSITION: {
                    consumer.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    consumer.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    float offX = side.func_82601_c();
                    float offY = side.func_96559_d();
                    float offZ = side.func_82599_e();
                    consumer.put(e, new float[]{offX, offY, offZ, 0.0f});
                    continue block6;
                }
                case UV: {
                    if (element.func_177369_e() == 0) {
                        consumer.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }
}

