/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.UsernameCache;
import uk.joshiejack.penguinlib.util.helpers.StringHelper;
import uk.joshiejack.penguinlib.world.teams.PenguinTeam;
import uk.joshiejack.penguinlib.world.teams.PenguinTeams;

public class JoinTeamCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return Commands.func_197057_a((String)"join").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            PenguinTeams teams = PenguinTeams.getTeamsFromContext((CommandContext<CommandSource>)ctx);
            PenguinTeam current = PenguinTeams.getTeamFromContext((CommandContext<CommandSource>)ctx);
            CommandSource source = (CommandSource)ctx.getSource();
            UUID playerID = source.func_197035_h().func_110124_au();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            PenguinTeam joining = teams.getTeamByName(name);
            if (!current.getID().equals(playerID)) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("command.penguinlib.team.join.must_leave", new Object[]{StringHelper.withClickableCommand("/penguin team leave", "command.penguinlib.team.join.must_leave.tooltip", new Object[0])}));
                return 0;
            }
            if (joining == null) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("command.penguinlib.team.join.not_exist", new Object[]{name}));
                return 0;
            }
            if (joining.getOwner() != null && !joining.isInvited(playerID)) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("command.penguinlib.team.join.not_invited", new Object[]{name, UsernameCache.getLastKnownUsername((UUID)joining.getOwner())}));
                return 0;
            }
            if (joining.getOwner() == null) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.penguinlib.team.join.success.owner", new Object[]{name}), false);
            } else {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.penguinlib.team.join.success.member", new Object[]{name}), false);
            }
            teams.changeTeam((CommandContext<CommandSource>)ctx, joining.getID(), pt -> {});
            return 1;
        }));
    }
}

