/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Locale;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import uk.joshiejack.penguinlib.events.DatabaseLoadedEvent;

@Mod.EventBusSubscriber(modid="penguinlib")
public class TimeUnitRegistry {
    private static final Object2LongMap<String> TIME_UNITS = new Object2LongOpenHashMap();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDatabaseLoaded(DatabaseLoadedEvent event) {
        TIME_UNITS.clear();
        event.table("time_unit").rows().forEach(row -> TIME_UNITS.put((Object)row.name(), row.getAsLong("duration")));
    }

    public static long get(String name) {
        return TIME_UNITS.containsKey((Object)name) ? TIME_UNITS.getLong((Object)name) : Long.MAX_VALUE;
    }

    public static enum Defaults {
        THREE_MINUTES(50L),
        FIVE_MINUTES(100L),
        QUARTER_HOUR(250L),
        HALF_HOUR(500L),
        HOUR(1000L),
        HALF_DAY(12000L),
        DAY(24000L),
        WEEK(168000L),
        YEAR(2880000L);

        private final long time;

        private Defaults(long time) {
            this.time = time;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public long getValue() {
            return this.time;
        }
    }
}

