/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import uk.joshiejack.penguinlib.events.DatabaseLoadedEvent;

@Mod.EventBusSubscriber(modid="penguinlib")
public class VillagerTrading {
    private static final Map<VillagerProfession, Int2ObjectMap<List<MerchantOffer>>> TRADES = new HashMap<VillagerProfession, Int2ObjectMap<List<MerchantOffer>>>();

    @SubscribeEvent
    public static void onReload(VillagerTradesEvent event) {
        if (TRADES.containsKey(event.getType())) {
            TRADES.get(event.getType()).forEach((tier, offers) -> offers.forEach(offer -> ((List)event.getTrades().get(tier)).add(new Trade((MerchantOffer)offer))));
        }
    }

    private static Int2ObjectMap<List<MerchantOffer>> get(VillagerProfession profession) {
        if (!TRADES.containsKey(profession)) {
            TRADES.put(profession, (Int2ObjectMap<List<MerchantOffer>>)new Int2ObjectOpenHashMap());
        }
        return TRADES.get(profession);
    }

    private static List<MerchantOffer> getList(Int2ObjectMap<List<MerchantOffer>> map, int tier) {
        if (!map.containsKey(tier)) {
            map.put(tier, new ArrayList());
        }
        return (List)map.get(tier);
    }

    @SubscribeEvent
    public static void onDatabaseLoaded(DatabaseLoadedEvent event) {
        TRADES.clear();
        event.table("villager_trades").rows().forEach(row -> {
            VillagerProfession profession = (VillagerProfession)ForgeRegistries.PROFESSIONS.getValue(row.getRL("profession"));
            Item input = row.item("input item");
            Item output = row.item("output item");
            int tier = row.getAsInt("tier");
            if (profession != null && input != null && output != null && tier >= 1 && tier <= 5) {
                VillagerTrading.getList(VillagerTrading.get(profession), row.getAsInt("tier")).add(new MerchantOffer(new ItemStack((IItemProvider)input, row.getAsInt("input amount")), new ItemStack((IItemProvider)output, row.getAsInt("output amount")), row.getAsInt("max trades"), row.getAsInt("experience"), row.getAsFloat("price multiplier")));
            }
        });
    }

    static class Trade
    implements VillagerTrades.ITrade {
        private final MerchantOffer offer;

        public Trade(MerchantOffer offer) {
            this.offer = offer;
        }

        @Nullable
        public MerchantOffer func_221182_a(@Nonnull Entity player, @Nonnull Random random) {
            return new MerchantOffer(this.offer.func_222218_a(), this.offer.func_222200_d(), this.offer.func_222214_i(), this.offer.func_222210_n(), this.offer.func_222211_m());
        }
    }
}

