/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import uk.joshiejack.penguinlib.data.custom.CustomObject;

public class CustomObjectAdapter
implements JsonSerializer<CustomObject>,
JsonDeserializer<CustomObject> {
    public JsonElement serialize(CustomObject src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        if (!src.name.equals("unnamed")) {
            result.addProperty("name", src.name);
        }
        result.addProperty("type", src.type);
        result.add("data", (JsonElement)context.serialize(src.data, ((CustomObject.Data)CustomObject.TYPE_REGISTRY.get((Object)src.type)).getClass()).getAsJsonObject());
        return result;
    }

    public CustomObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        CustomObject object = new CustomObject();
        object.name = jsonObject.has("name") ? jsonObject.get("name").getAsString() : "unnamed";
        object.type = jsonObject.get("type").getAsString();
        if (jsonObject.has("data")) {
            Class<?> clazz = ((CustomObject.Data)CustomObject.TYPE_REGISTRY.get((Object)object.type)).getClass();
            object.data = (CustomObject.Data)context.deserialize((JsonElement)jsonObject.getAsJsonObject("data"), clazz);
        }
        return object;
    }
}

