/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.database;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class CSVUtils {
    private static final char DEFAULT_SEPARATOR = ',';
    private static final char DEFAULT_QUOTE = '\"';

    private static String toString(List<Character> chars) {
        return chars.size() > 0 ? chars.stream().map(Object::toString).reduce((acc, e) -> acc + e).get() : "";
    }

    public static List<String> parse(String line) {
        ArrayList list = Lists.newArrayList();
        char[] chars = line.toCharArray();
        boolean previousWasQuotes = false;
        boolean insideQuotes = false;
        ArrayList characters = Lists.newArrayList();
        for (char c : chars) {
            if (c == '\"' && !previousWasQuotes) {
                insideQuotes = !insideQuotes;
                previousWasQuotes = true;
                continue;
            }
            if (c == ',' && !insideQuotes) {
                list.add(CSVUtils.toString(characters));
                characters = Lists.newArrayList();
                previousWasQuotes = false;
                continue;
            }
            characters.add(Character.valueOf(c));
            previousWasQuotes = false;
        }
        list.add(CSVUtils.toString(characters));
        return list;
    }

    public static List<String> parseLine(String cvsLine) {
        return CSVUtils.parseLine(cvsLine, ',', '\"');
    }

    public static List<String> parseLine(String cvsLine, char separators) {
        return CSVUtils.parseLine(cvsLine, separators, '\"');
    }

    private static List<String> parseLine(String cvsLine, char separators, char customQuote) {
        char[] chars;
        ArrayList<String> result = new ArrayList<String>();
        if (cvsLine == null || cvsLine.isEmpty()) {
            return result;
        }
        if (customQuote == ' ') {
            customQuote = (char)34;
        }
        if (separators == ' ') {
            separators = (char)44;
        }
        StringBuffer curVal = new StringBuffer();
        boolean inQuotes = false;
        boolean startCollectChar = false;
        boolean doubleQuotesInColumn = false;
        for (char ch : chars = cvsLine.toCharArray()) {
            if (inQuotes) {
                startCollectChar = true;
                if (ch == customQuote) {
                    inQuotes = false;
                    doubleQuotesInColumn = false;
                    continue;
                }
                if (ch == '\"') {
                    if (doubleQuotesInColumn) continue;
                    curVal.append(ch);
                    doubleQuotesInColumn = true;
                    continue;
                }
                curVal.append(ch);
                continue;
            }
            if (ch == customQuote) {
                inQuotes = true;
                if (chars[0] != '\"' && customQuote == '\"') {
                    curVal.append('\"');
                }
                if (!startCollectChar) continue;
                curVal.append('\"');
                continue;
            }
            if (ch == separators) {
                result.add(curVal.toString());
                curVal = new StringBuffer();
                startCollectChar = false;
                continue;
            }
            if (ch == '\r') continue;
            if (ch == '\n') break;
            curVal.append(ch);
        }
        result.add(curVal.toString());
        return result;
    }

    @SafeVarargs
    public static <T> String join(T ... elements) {
        ArrayList list = Lists.newArrayList();
        for (T t : elements) {
            String append = t.toString();
            if (append.contains("\"")) {
                append = append.replace("\"", "\"\"");
            }
            if (append.contains(",")) {
                append = "\"" + append + "\"";
            }
            list.add(append.contains("\n") ? StringEscapeUtils.escapeJava((String)append) : append);
        }
        return StringUtils.join((Iterable)list, (char)',');
    }
}

