/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.database;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import uk.joshiejack.penguinlib.PenguinLib;
import uk.joshiejack.penguinlib.data.database.Table;
import uk.joshiejack.penguinlib.util.Patterns;

public class Row {
    public static final Row EMPTY = new Row(Table.EMPTY, new String[0], new String[0]);
    private final Map<String, Object> data = Maps.newHashMap();
    private final Table table;

    Row(Table table, String[] labelset, String[] dataset) {
        try {
            for (int i = 0; i < labelset.length; ++i) {
                this.set(labelset[i], dataset[i]);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            PenguinLib.LOGGER.log(Level.ERROR, "Failed to set the values for the label set: " + Arrays.toString(labelset) + " with the data " + Arrays.toString(dataset));
            throw ex;
        }
        this.table = table;
    }

    public String get() {
        return (String)this.data.values().stream().findFirst().get();
    }

    public <T> T get(String label) {
        return (T)this.data.get(label.toLowerCase(Locale.ENGLISH));
    }

    public int getTime(String name) {
        String entry = this.get(name).toString();
        if (!entry.contains(":")) {
            return -1;
        }
        String[] split = this.get(name).toString().split(":");
        int hours = Integer.parseInt(split[0]);
        int minutes = Integer.parseInt(split[1]);
        int seconds = split.length > 2 ? Integer.parseInt(split[2]) : 0;
        int totalSeconds = hours * 3600 + minutes * 60 + seconds;
        return (int)(24000.0 / (86400.0 / (double)totalSeconds));
    }

    public ResourceLocation getScript() {
        return new ResourceLocation(this.get("script").toString().replace("/", "_"));
    }

    public <E extends Enum<E>> E getAsEnum(Class<E> clazz) {
        return this.getAsEnum(clazz, clazz.getSimpleName().toLowerCase(Locale.ROOT));
    }

    private <E extends Enum<E>> E getAsEnum(Class<E> clazz, String field) {
        return Enum.valueOf(clazz, this.get(field).toString().toUpperCase(Locale.ROOT));
    }

    public String id() {
        return (String)this.get("id");
    }

    public ItemStack icon() {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public Ingredient holder() {
        return Ingredient.field_193370_a;
    }

    public EntityType<?> entity() {
        return this.entity("entity");
    }

    public EntityType<?> entity(String name) {
        return (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(this.get(name).toString()));
    }

    public ResourceLocation getRL(String name) {
        return new ResourceLocation((String)this.get(name));
    }

    public Block block() {
        return this.block("block");
    }

    public Block block(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.get(name).toString()));
    }

    public Item item() {
        return this.item("item");
    }

    public Item item(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.get(name).toString()));
    }

    public float getAsFloat(String label) {
        return Float.parseFloat(this.get(label).toString());
    }

    public long getAsLong(String label) {
        return Long.parseLong(this.get(label).toString().trim());
    }

    public double getAsDouble(String label) {
        return Double.parseDouble(this.get(label).toString().trim());
    }

    public int getAsInt(String label) {
        return Integer.parseInt(this.get(label).toString());
    }

    public int getColor(String label) {
        return Integer.parseInt(this.get(label).toString().replace("0x", "").replace("#", ""), 16);
    }

    public boolean isEmpty(String label) {
        if (this.get(label) == null) {
            return true;
        }
        String name = this.get(label).toString();
        return name.isEmpty() || name.equals("none") || name.equals("default");
    }

    public Effect effect() {
        return this.effect("effect");
    }

    public Effect effect(String name) {
        return (Effect)ForgeRegistries.POTIONS.getValue(this.getRL(name));
    }

    public ITag.INamedTag<Item> itemTag() {
        return this.itemTag("tag");
    }

    public ITag.INamedTag<Item> itemTag(String name) {
        return ItemTags.createOptional((ResourceLocation)this.getRL(name));
    }

    public ITag.INamedTag<Block> blockTag() {
        return this.blockTag("tag");
    }

    public ITag.INamedTag<Block> blockTag(String name) {
        return BlockTags.createOptional((ResourceLocation)this.getRL(name));
    }

    public String toString() {
        return Arrays.toString(this.data.values().toArray());
    }

    public boolean contains(String match) {
        for (Object object : this.data.values()) {
            if (!(object instanceof String) || !match.equals(object)) continue;
            return true;
        }
        return false;
    }

    public void set(String label, String value) {
        if (Patterns.BOOLEAN_PATTERN.matcher(value).matches()) {
            this.data.put(label, Boolean.valueOf(value));
        } else if (Patterns.DOUBLE_PATTERN.matcher(value).matches()) {
            this.data.put(label, Double.valueOf(value));
        } else if (Patterns.INTEGER_PATTERN.matcher(value).matches()) {
            this.data.put(label, Integer.valueOf(value));
        } else {
            this.data.put(label, value);
        }
    }

    public String name() {
        return (String)this.get("name");
    }

    public boolean isTrue(String name) {
        Object ret = this.get(name);
        return ret instanceof Boolean ? (Boolean)ret : Boolean.parseBoolean(ret.toString());
    }
}

