/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.generators.builders;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import uk.joshiejack.penguinlib.data.PenguinRegistries;
import uk.joshiejack.penguinlib.data.generators.builders.NoteBuilder;
import uk.joshiejack.penguinlib.data.generators.builders.SimplePenguinBuilder;
import uk.joshiejack.penguinlib.note.Category;
import uk.joshiejack.penguinlib.util.icon.EntityIcon;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;
import uk.joshiejack.penguinlib.util.icon.ItemListIcon;
import uk.joshiejack.penguinlib.util.icon.TagIcon;
import uk.joshiejack.penguinlib.util.icon.TextureIcon;

public class CategoryBuilder
extends SimplePenguinBuilder<Category> {
    private Icon icon = new ItemIcon(ItemStack.field_190927_a);
    private List<Pair<String, NoteBuilder>> notes = new ArrayList<Pair<String, NoteBuilder>>();

    public CategoryBuilder() {
        super((IRecipeSerializer)PenguinRegistries.CATEGORY_SERIALIZER.get());
    }

    public static CategoryBuilder category() {
        return new CategoryBuilder();
    }

    public CategoryBuilder withItemIcon(Item item) {
        this.icon = new ItemIcon(new ItemStack((IItemProvider)item));
        return this;
    }

    public CategoryBuilder withTextureIcon(ResourceLocation texture, int x, int y) {
        this.icon = new TextureIcon(texture, x, y);
        return this;
    }

    public CategoryBuilder withPenguinIcon(int x, int y) {
        this.icon = new TextureIcon(Icon.DEFAULT_LOCATION, x, y);
        return this;
    }

    public CategoryBuilder withEntityIcon(EntityType<?> type, int scale) {
        this.icon = new EntityIcon(type, scale);
        return this;
    }

    public CategoryBuilder withNoteIcon() {
        this.icon = new TextureIcon(Icon.DEFAULT_LOCATION, 0, 0);
        return this;
    }

    public CategoryBuilder withTagIcon(ITag.INamedTag<Item> tag) {
        this.icon = new TagIcon(tag);
        return this;
    }

    public CategoryBuilder withListIcon(Item ... items) {
        this.icon = new ItemListIcon(Lists.newArrayList((Object[])items).stream().map(ItemStack::new).collect(Collectors.toList()));
        return this;
    }

    public NoteBuilder withNote(String name) {
        NoteBuilder builder = NoteBuilder.note(this);
        this.notes.add((Pair<String, NoteBuilder>)Pair.of((Object)name, (Object)builder));
        return builder;
    }

    @Override
    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation resource) {
        super.save(consumer, resource);
        this.notes.forEach(pair -> ((NoteBuilder)pair.getRight()).withCategory(this).save(consumer, new ResourceLocation(resource.func_110624_b(), (String)pair.getLeft())));
    }

    public void func_218610_a(@Nonnull JsonObject json) {
        json.add("icon", this.icon.toJson(new JsonObject()));
    }
}

