/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.generators.builders;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import uk.joshiejack.penguinlib.data.PenguinRegistries;
import uk.joshiejack.penguinlib.data.generators.builders.CategoryBuilder;
import uk.joshiejack.penguinlib.data.generators.builders.SimplePenguinBuilder;
import uk.joshiejack.penguinlib.note.Note;
import uk.joshiejack.penguinlib.note.type.NoteType;
import uk.joshiejack.penguinlib.util.icon.EntityIcon;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;
import uk.joshiejack.penguinlib.util.icon.ItemListIcon;
import uk.joshiejack.penguinlib.util.icon.TagIcon;
import uk.joshiejack.penguinlib.util.icon.TextureIcon;

public class NoteBuilder
extends SimplePenguinBuilder<Note> {
    private ResourceLocation category;
    private boolean isHidden;
    private boolean locked;
    private String type;
    private Icon icon = new ItemIcon(ItemStack.field_190927_a);
    private CategoryBuilder categoryBuilder;

    public NoteBuilder() {
        super((IRecipeSerializer)PenguinRegistries.NOTE_SERIALIZER.get());
    }

    public static NoteBuilder note() {
        return new NoteBuilder();
    }

    public static NoteBuilder note(CategoryBuilder builder) {
        NoteBuilder note = NoteBuilder.note();
        note.categoryBuilder = builder;
        return note;
    }

    public CategoryBuilder end() {
        return this.categoryBuilder;
    }

    public NoteBuilder withCategory(CategoryBuilder builder) {
        this.category = builder.func_200442_b();
        return this;
    }

    public NoteBuilder setNoteType(String type) {
        this.type = type;
        return this;
    }

    public NoteBuilder setNoteType(NoteType type) {
        return this.setNoteType(type.toString());
    }

    public NoteBuilder setHidden() {
        this.isHidden = true;
        return this;
    }

    public NoteBuilder setLockedByDefault() {
        this.locked = true;
        return this;
    }

    public NoteBuilder withItemIcon(Item item) {
        this.icon = new ItemIcon(new ItemStack((IItemProvider)item));
        return this;
    }

    public NoteBuilder withTextureIcon(ResourceLocation texture, int x, int y) {
        this.icon = new TextureIcon(texture, x, y);
        return this;
    }

    public NoteBuilder withPenguinIcon(int x, int y) {
        this.icon = new TextureIcon(Icon.DEFAULT_LOCATION, x, y);
        return this;
    }

    public NoteBuilder withEntityIcon(EntityType<?> type, int scale) {
        this.icon = new EntityIcon(type, scale);
        return this;
    }

    public NoteBuilder withNoteIcon() {
        this.icon = new TextureIcon(Icon.DEFAULT_LOCATION, 0, 0);
        return this;
    }

    public NoteBuilder withTagIcon(ITag.INamedTag<Item> tag) {
        this.icon = new TagIcon(tag);
        return this;
    }

    public NoteBuilder withListIcon(Item ... items) {
        this.icon = new ItemListIcon(Lists.newArrayList((Object[])items).stream().map(ItemStack::new).collect(Collectors.toList()));
        return this;
    }

    public void func_218610_a(@Nonnull JsonObject json) {
        if (this.isHidden) {
            json.addProperty("hidden", Boolean.valueOf(true));
        }
        if (this.locked) {
            json.addProperty("locked", Boolean.valueOf(true));
        }
        if (!Strings.isNullOrEmpty((String)this.type)) {
            json.addProperty("note type", this.type);
        }
        json.addProperty("category", this.category.toString());
        json.add("icon", this.icon.toJson(new JsonObject()));
    }
}

