/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.generators.builders;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class SimplePenguinRecipeBuilder {
    protected final Item result;
    protected final Ingredient ingredient;
    protected final int count;
    protected final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    protected final IRecipeSerializer<?> type;

    public SimplePenguinRecipeBuilder(IRecipeSerializer<?> serializer, Ingredient ingredient, IItemProvider output, int amount) {
        this.type = serializer;
        this.result = output.func_199767_j();
        this.ingredient = ingredient;
        this.count = amount;
    }

    public SimplePenguinRecipeBuilder unlocks(String name, ICriterionInstance criterion) {
        this.advancement.func_200275_a(name, criterion);
        return this;
    }

    public void save(Consumer<IFinishedRecipe> consumer, String name) {
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (new ResourceLocation(name).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Single Item Recipe " + name + " should remove its 'save' argument");
        }
        this.save(consumer, new ResourceLocation(name));
    }

    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation resource) {
        this.ensureValid(resource);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)resource)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)resource)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(this.accept(resource));
    }

    protected IFinishedRecipe accept(ResourceLocation resource) {
        assert (this.result.func_77640_w() != null);
        return new Result(resource, this.type, this.ingredient, this.result, this.count, this.advancement, new ResourceLocation(resource.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + resource.func_110623_a()));
    }

    protected void ensureValid(ResourceLocation p_218646_1_) {
        if (this.advancement.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_218646_1_);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item result;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final IRecipeSerializer<?> type;

        public Result(ResourceLocation rl, IRecipeSerializer<?> serializer, Ingredient ingredient, Item output, int count, Advancement.Builder advancementBuilder, ResourceLocation advancementID) {
            this.id = rl;
            this.type = serializer;
            this.ingredient = ingredient;
            this.result = output;
            this.count = count;
            this.advancement = advancementBuilder;
            this.advancementId = advancementID;
        }

        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.ingredient.func_200304_c());
            json.addProperty("result", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            json.addProperty("count", (Number)this.count);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.type;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

