/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddLootGlobalModifier
extends LootModifier {
    private final List<Item> items = new ArrayList<Item>();
    private final boolean clearItems;
    private final int itemCount;

    public AddLootGlobalModifier(ILootCondition[] conditions, List<Item> items, boolean clearItems, int itemCount) {
        super(conditions);
        this.items.addAll(items);
        this.clearItems = clearItems;
        this.itemCount = itemCount;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.clearItems) {
            generatedLoot.clear();
        }
        for (int i = 0; i < this.itemCount; ++i) {
            generatedLoot.add(new ItemStack((IItemProvider)this.items.get(context.func_216032_b().nextInt(this.items.size()))));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddLootGlobalModifier> {
        public AddLootGlobalModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"items");
            ArrayList<Item> items = new ArrayList<Item>();
            for (int i = 0; i < array.size(); ++i) {
                String item = array.get(i).getAsString();
                if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(item))) continue;
                items.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)));
            }
            boolean clear = object.has("clear_items") && JSONUtils.func_151212_i((JsonObject)object, (String)"clear_items");
            int itemCount = object.has("item_count") ? JSONUtils.func_151203_m((JsonObject)object, (String)"item_count") : 1;
            return new AddLootGlobalModifier(conditions, items, clear, itemCount);
        }

        public JsonObject write(AddLootGlobalModifier instance) {
            JsonArray array = new JsonArray();
            for (Item item : instance.items) {
                array.add(item.getRegistryName().toString());
            }
            JsonObject object = new JsonObject();
            object.add("items", (JsonElement)array);
            if (instance.clearItems) {
                object.addProperty("clear_items", Boolean.valueOf(true));
            }
            if (instance.itemCount > 1) {
                object.addProperty("item_count", (Number)instance.itemCount);
            }
            return object;
        }
    }
}

