/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.item.base;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import uk.joshiejack.penguinlib.events.UseWateringCanEvent;
import uk.joshiejack.penguinlib.util.handlers.SingleFluidHandler;
import uk.joshiejack.penguinlib.util.helpers.FluidHelper;

public abstract class AbstractWateringCanItem
extends Item {
    private final int maxWater;

    public AbstractWateringCanItem(Item.Properties properties, int maxWater) {
        super(properties);
        this.maxWater = maxWater;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new SingleFluidHandler(stack, (Fluid)Fluids.field_204546_a, this.maxWater);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)(this.maxWater - FluidHelper.getFluidCapacityFromStack(stack)) / (double)this.maxWater;
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return FluidHelper.getFluidCapacityFromStack(stack) > 0 ? 28121 : 0x555555;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.attemptToFill(world, player, stack)) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    private boolean attemptToFill(World world, PlayerEntity player, ItemStack stack) {
        BlockState state;
        BlockRayTraceResult rayTraceResult = AbstractWateringCanItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (rayTraceResult != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(new BlockPos(rayTraceResult.func_216347_e()))).func_185904_a() == Material.field_151586_h) {
            return FluidHelper.fillContainer(stack, this.maxWater);
        }
        return false;
    }

    protected void applyBonemealEffect(World world, BlockPos pos, PlayerEntity player, ItemStack itemstack, Hand hand) {
    }

    private Event.Result onWateringCanUse(ItemStack stack, PlayerEntity player, World worldIn, BlockPos pos) {
        UseWateringCanEvent event = new UseWateringCanEvent(player, stack, worldIn, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return Event.Result.DENY;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!player.func_184812_l_()) {
                FluidHelper.drainContainer(stack, 1);
            }
            return Event.Result.ALLOW;
        }
        return Event.Result.DEFAULT;
    }

    public Set<BlockPos> getPositions(PlayerEntity player, World world, BlockPos pos) {
        return Sets.newHashSet((Object[])new BlockPos[]{pos, pos.func_177977_b()});
    }

    public boolean water(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Hand hand) {
        this.applyBonemealEffect(world, pos, player, stack, hand);
        Event.Result hook = this.onWateringCanUse(stack, player, world, pos);
        if (hook != Event.Result.DEFAULT) {
            return hook == Event.Result.ALLOW;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_235904_r_().contains(BlockStateProperties.field_208133_ah) && (Integer)state.func_177229_b((Property)BlockStateProperties.field_208133_ah) != 7) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208133_ah, (Comparable)Integer.valueOf(7)), 2);
            if (!player.func_184812_l_() && !stack.func_190926_b()) {
                FluidHelper.drainContainer(stack, 1);
            }
            return true;
        }
        return false;
    }

    private void onWatered(PlayerEntity player, World world, BlockPos pos, ItemStack itemstack) {
        MinecraftForge.EVENT_BUS.post((Event)new UseWateringCanEvent.Post(player, itemstack, world, pos));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        Hand hand = ctx.func_221531_n();
        Direction direction = ctx.func_196000_l();
        BlockPos pos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        ItemStack itemstack = player.func_184586_b(hand);
        if (FluidHelper.getFluidCapacityFromStack(itemstack) > 0) {
            if (!player.func_175151_a(pos.func_177971_a(direction.func_176730_m()), direction, itemstack)) {
                return ActionResultType.FAIL;
            }
            if (world.func_230315_m_().func_236040_e_()) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
                }
                ItemStack stack = player.func_184586_b(hand);
                if (!player.func_184812_l_() && !stack.func_190926_b()) {
                    FluidHelper.drainContainer(stack, 1);
                }
                return ActionResultType.SUCCESS;
            }
            boolean used = false;
            for (BlockPos target : this.getPositions(player, world, pos)) {
                if (FluidHelper.getFluidCapacityFromStack(itemstack) <= 0) break;
                if (!this.water(player, world, target, itemstack, hand)) continue;
                world.func_184133_a(null, target, SoundEvents.field_187549_bG, SoundCategory.NEUTRAL, player.func_70681_au().nextFloat() * 0.25f + 0.7f, player.func_70681_au().nextFloat() + 0.5f);
                for (int i = 0; i < 60; ++i) {
                    double x = (float)pos.func_177958_n() + player.func_70681_au().nextFloat();
                    double z = (float)pos.func_177952_p() + player.func_70681_au().nextFloat();
                    world.func_195589_b((IParticleData)ParticleTypes.field_218422_X, x, (double)pos.func_177956_o() + 1.0, z, 0.0, 0.0, 0.0);
                }
                this.onWatered(player, world, target, itemstack);
                used = true;
            }
            return used ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.FAIL;
    }

    private ItemStack createFilledWateringCan(ItemStack stack) {
        FluidHelper.fillContainer(stack, this.maxWater);
        return stack;
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null) {
                items.add((Object)this.createFilledWateringCan(new ItemStack((IItemProvider)this)));
            } else {
                items.add((Object)new ItemStack((IItemProvider)this));
            }
        }
    }
}

