/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.network.packet;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import uk.joshiejack.penguinlib.network.packet.BlockRenderUpdatePacket;
import uk.joshiejack.penguinlib.tile.inventory.AbstractInventoryTileEntity;
import uk.joshiejack.penguinlib.util.PenguinLoader;

@PenguinLoader.Packet(value=NetworkDirection.PLAY_TO_CLIENT)
public class SetInventorySlotPacket
extends BlockRenderUpdatePacket {
    private int slot;
    private ItemStack stack;

    public SetInventorySlotPacket() {
    }

    public SetInventorySlotPacket(BlockPos pos, int slot, ItemStack stack) {
        super(pos);
        this.slot = slot;
        this.stack = stack;
    }

    @Override
    public void encode(PacketBuffer to) {
        super.encode(to);
        to.writeInt(this.slot);
        to.writeItemStack(this.stack, false);
    }

    @Override
    public void decode(PacketBuffer from) {
        super.decode(from);
        this.slot = from.readInt();
        this.stack = from.func_150791_c();
    }

    @Override
    public void handle(PlayerEntity player) {
        TileEntity tile = player.field_70170_p.func_175625_s(this.pos);
        if (tile instanceof AbstractInventoryTileEntity) {
            LazyOptional handler = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            handler.ifPresent(itemHandler -> {
                if (itemHandler instanceof IItemHandlerModifiable) {
                    ((IItemHandlerModifiable)itemHandler).setStackInSlot(this.slot, this.stack);
                }
            });
        }
        super.handle(player);
    }
}

